/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class PackageAdminServiceTracker
implements ServiceListener {
    private BundleContext _context;
    private List<BundleActivator> _activatedFragments = new ArrayList<BundleActivator>();
    private boolean _fragmentsWereActivated = false;
    private StartLevel _startLevel;
    private int _maxStartLevel = 6;
    public static PackageAdminServiceTracker INSTANCE = null;

    public PackageAdminServiceTracker(BundleContext context) {
        INSTANCE = this;
        this._context = context;
        if (!this.setup()) {
            try {
                this._context.addServiceListener((ServiceListener)this, "(objectclass=" + PackageAdmin.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setup() {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        boolean bl = this._fragmentsWereActivated = sr != null;
        if (sr != null) {
            this.invokeFragmentActivators(sr);
        }
        if ((sr = this._context.getServiceReference(StartLevel.class.getName())) != null) {
            this._startLevel = (StartLevel)this._context.getService(sr);
            try {
                this._maxStartLevel = Integer.parseInt(System.getProperty("osgi.startLevel", "6"));
            }
            catch (Exception e) {
                this._maxStartLevel = 6;
            }
        }
        return this._fragmentsWereActivated;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            this.invokeFragmentActivators(event.getServiceReference());
        }
    }

    public Bundle[] getFragments(Bundle bundle) {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        if (sr == null) {
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        return admin.getFragments(bundle);
    }

    public Bundle[] getFragmentsAndRequiredBundles(Bundle bundle) {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        if (sr == null) {
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        LinkedHashMap<String, Bundle> deps = new LinkedHashMap<String, Bundle>();
        this.collectFragmentsAndRequiredBundles(bundle, admin, deps, false);
        return deps.values().toArray(new Bundle[deps.size()]);
    }

    protected void collectFragmentsAndRequiredBundles(Bundle bundle, PackageAdmin admin, Map<String, Bundle> deps, boolean onlyReexport) {
        Bundle[] fragments = admin.getFragments(bundle);
        if (fragments != null) {
            for (Bundle f : fragments) {
                if (deps.keySet().contains(f.getSymbolicName())) continue;
                deps.put(f.getSymbolicName(), f);
                this.collectRequiredBundles(f, admin, deps, onlyReexport);
            }
        }
        this.collectRequiredBundles(bundle, admin, deps, onlyReexport);
    }

    protected void collectRequiredBundles(Bundle bundle, PackageAdmin admin, Map<String, Bundle> deps, boolean onlyReexport) {
        String requiredBundleHeader = (String)bundle.getHeaders().get("Require-Bundle");
        if (requiredBundleHeader == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(requiredBundleHeader, ",");
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken().trim();
            StringTokenizer tokenizer2 = new StringTokenizer(tok, ";");
            String symbolicName = tokenizer2.nextToken().trim();
            if (deps.keySet().contains(symbolicName)) continue;
            String versionRange = null;
            boolean reexport = false;
            while (tokenizer2.hasMoreTokens()) {
                String next = tokenizer2.nextToken().trim();
                if (next.startsWith("bundle-version=")) {
                    if (next.startsWith("bundle-version=\"") || next.startsWith("bundle-version='")) {
                        versionRange = next.substring("bundle-version=\"".length(), next.length() - 1);
                        continue;
                    }
                    versionRange = next.substring("bundle-version=".length());
                    continue;
                }
                if (!next.equals("visibility:=reexport")) continue;
                reexport = true;
            }
            if (!reexport && onlyReexport) {
                return;
            }
            Bundle[] reqBundles = admin.getBundles(symbolicName, versionRange);
            if (reqBundles == null || reqBundles.length == 0) continue;
            Bundle reqBundle = null;
            for (Bundle b : reqBundles) {
                if (b.getState() != 32 && b.getState() != 8) continue;
                reqBundle = b;
                break;
            }
            if (reqBundle == null) {
                reqBundle = reqBundles[0];
            }
            deps.put(reqBundle.getSymbolicName(), reqBundle);
            this.collectFragmentsAndRequiredBundles(reqBundle, admin, deps, true);
        }
    }

    private void invokeFragmentActivators(ServiceReference sr) {
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        Bundle[] fragments = admin.getFragments(this._context.getBundle());
        if (fragments == null) {
            return;
        }
        for (Bundle frag : fragments) {
            try {
                String fragmentActivator = frag.getSymbolicName() + ".FragmentActivator";
                Class<?> c = Class.forName(fragmentActivator);
                if (c == null) continue;
                BundleActivator bActivator = (BundleActivator)c.newInstance();
                bActivator.start(this._context);
                this._activatedFragments.add(bActivator);
            }
            catch (NullPointerException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        INSTANCE = null;
        for (BundleActivator fragAct : this._activatedFragments) {
            try {
                fragAct.stop(this._context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean frameworkHasCompletedAutostarts() {
        return this._startLevel == null ? true : this._startLevel.getStartLevel() >= this._maxStartLevel;
    }
}

