/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpExchange {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final AtomicBoolean requestComplete = new AtomicBoolean();
    private final AtomicBoolean responseComplete = new AtomicBoolean();
    private final AtomicInteger complete = new AtomicInteger();
    private final AtomicReference<HttpChannel> channel = new AtomicReference();
    private final HttpConversation conversation;
    private final HttpDestination destination;
    private final Request request;
    private final List<Response.ResponseListener> listeners;
    private final HttpResponse response;
    private volatile Throwable requestFailure;
    private volatile Throwable responseFailure;

    public HttpExchange(HttpConversation conversation, HttpDestination destination, Request request, List<Response.ResponseListener> listeners) {
        this.conversation = conversation;
        this.destination = destination;
        this.request = request;
        this.listeners = listeners;
        this.response = new HttpResponse(request, listeners);
        conversation.getExchanges().offer(this);
        conversation.updateResponseListeners(null);
    }

    public HttpConversation getConversation() {
        return this.conversation;
    }

    public Request getRequest() {
        return this.request;
    }

    public Throwable getRequestFailure() {
        return this.requestFailure;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Throwable getResponseFailure() {
        return this.responseFailure;
    }

    public void associate(HttpChannel channel) {
        if (!this.channel.compareAndSet(null, channel)) {
            throw new IllegalStateException();
        }
    }

    public void disassociate(HttpChannel channel) {
        if (!this.channel.compareAndSet(channel, null)) {
            throw new IllegalStateException();
        }
    }

    public boolean requestComplete() {
        return this.requestComplete.compareAndSet(false, true);
    }

    public boolean responseComplete() {
        return this.responseComplete.compareAndSet(false, true);
    }

    public Result terminateRequest(Throwable failure) {
        int requestSuccess = 3;
        int requestFailure = 1;
        return this.terminate(failure == null ? requestSuccess : requestFailure, failure);
    }

    public Result terminateResponse(Throwable failure) {
        if (failure == null) {
            int responseSuccess = 12;
            return this.terminate(responseSuccess, failure);
        }
        this.proceed(false);
        int responseFailure = 4;
        return this.terminate(responseFailure, failure);
    }

    private Result terminate(int code, Throwable failure) {
        int terminated;
        int current;
        block4: {
            int candidate;
            do {
                boolean updateable;
                boolean bl = updateable = ((current = this.complete.get()) & code) == 0;
                if (!updateable) break block4;
            } while (!this.complete.compareAndSet(current, candidate = current | code));
            current = candidate;
            if ((code & 1) == 1) {
                this.requestFailure = failure;
            } else {
                this.responseFailure = failure;
            }
            LOG.debug("{} updated", new Object[]{this});
        }
        if ((current & (terminated = 5)) == terminated) {
            LOG.debug("{} terminated", new Object[]{this});
            this.conversation.complete();
            return new Result(this.getRequest(), this.getRequestFailure(), this.getResponse(), this.getResponseFailure());
        }
        return null;
    }

    public boolean abort(Throwable cause) {
        if (this.destination.remove(this)) {
            this.destination.abort(this, cause);
            LOG.debug("Aborted while queued {}: {}", new Object[]{this, cause});
            return true;
        }
        HttpChannel channel = this.channel.get();
        if (channel == null) {
            return false;
        }
        boolean aborted = channel.abort(cause);
        LOG.debug("Aborted while active ({}) {}: {}", new Object[]{aborted, this, cause});
        return aborted;
    }

    public void resetResponse(boolean success) {
        this.responseComplete.set(false);
        int responseSuccess = 12;
        int responseFailure = 4;
        int code = success ? responseSuccess : responseFailure;
        this.complete.addAndGet(-code);
    }

    public void proceed(boolean proceed) {
        HttpChannel channel = this.channel.get();
        if (channel != null) {
            channel.proceed(this, proceed);
        }
    }

    private String toString(int code) {
        String padding = "0000";
        String status = Integer.toBinaryString(code);
        return String.format("%s@%x status=%s%s", HttpExchange.class.getSimpleName(), this.hashCode(), padding.substring(status.length()), status);
    }

    public String toString() {
        return this.toString(this.complete.get());
    }
}

