/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;

public class DefaultBundleClassLoaderHelper
implements BundleClassLoaderHelper {
    private static final Logger LOG = Log.getLogger(BundleClassLoaderHelper.class);
    private static boolean identifiedOsgiImpl = false;
    private static boolean isEquinox = false;
    private static boolean isFelix = false;
    private static Method Equinox_BundleHost_getBundleLoader_method;
    private static Method Equinox_BundleLoader_createClassLoader_method;
    private static Field Felix_BundleImpl_m_modules_field;
    private static Field Felix_ModuleImpl_m_classLoader_field;
    private static Method Felix_adapt_method;
    private static Method Felix_bundle_wiring_getClassLoader_method;
    private static Class Felix_bundleWiringClazz;
    private static Boolean isFelix403;

    private static void init(Bundle bundle) {
        identifiedOsgiImpl = true;
        try {
            isEquinox = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.framework.internal.core.BundleHost") != null;
        }
        catch (Throwable t) {
            isEquinox = false;
        }
        if (!isEquinox) {
            try {
                isFelix = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl") != null;
            }
            catch (Throwable t2) {
                isFelix = false;
            }
        }
    }

    @Override
    public ClassLoader getBundleClassLoader(Bundle bundle) {
        String bundleActivator = (String)bundle.getHeaders().get("Bundle-Activator");
        if (bundleActivator == null) {
            bundleActivator = (String)bundle.getHeaders().get("Jetty-ClassInBundle");
        }
        if (bundleActivator != null) {
            try {
                return bundle.loadClass(bundleActivator).getClassLoader();
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!identifiedOsgiImpl) {
            DefaultBundleClassLoaderHelper.init(bundle);
        }
        if (isEquinox) {
            return DefaultBundleClassLoaderHelper.internalGetEquinoxBundleClassLoader(bundle);
        }
        if (isFelix) {
            return DefaultBundleClassLoaderHelper.internalGetFelixBundleClassLoader(bundle);
        }
        LOG.warn("No classloader found for bundle " + bundle.getSymbolicName(), new Object[0]);
        return null;
    }

    private static ClassLoader internalGetEquinoxBundleClassLoader(Bundle bundle) {
        try {
            if (Equinox_BundleHost_getBundleLoader_method == null) {
                Equinox_BundleHost_getBundleLoader_method = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.framework.internal.core.BundleHost").getDeclaredMethod("getBundleLoader", new Class[0]);
                Equinox_BundleHost_getBundleLoader_method.setAccessible(true);
            }
            Object bundleLoader = Equinox_BundleHost_getBundleLoader_method.invoke((Object)bundle, new Object[0]);
            if (Equinox_BundleLoader_createClassLoader_method == null && bundleLoader != null) {
                Equinox_BundleLoader_createClassLoader_method = bundleLoader.getClass().getClassLoader().loadClass("org.eclipse.osgi.internal.loader.BundleLoader").getDeclaredMethod("createClassLoader", new Class[0]);
                Equinox_BundleLoader_createClassLoader_method.setAccessible(true);
            }
            return (ClassLoader)Equinox_BundleLoader_createClassLoader_method.invoke(bundleLoader, new Object[0]);
        }
        catch (Throwable t) {
            LOG.warn(t);
            LOG.warn("No classloader for equinox platform for bundle " + bundle.getSymbolicName(), new Object[0]);
            return null;
        }
    }

    private static ClassLoader internalGetFelixBundleClassLoader(Bundle bundle) {
        Object currentModuleImpl;
        DefaultBundleClassLoaderHelper.initFelix403(bundle);
        if (isFelix403.booleanValue()) {
            try {
                Object wiring = Felix_adapt_method.invoke((Object)bundle, Felix_bundleWiringClazz);
                ClassLoader cl = (ClassLoader)Felix_bundle_wiring_getClassLoader_method.invoke(wiring, new Object[0]);
                return cl;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        if (Felix_BundleImpl_m_modules_field == null) {
            try {
                Class<?> bundleImplClazz = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl");
                Felix_BundleImpl_m_modules_field = bundleImplClazz.getDeclaredField("m_modules");
                Felix_BundleImpl_m_modules_field.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                LOG.warn((Throwable)e);
            }
        }
        try {
            Object[] moduleArray = (Object[])Felix_BundleImpl_m_modules_field.get(bundle);
            currentModuleImpl = moduleArray[moduleArray.length - 1];
        }
        catch (Throwable t2) {
            try {
                List moduleArray = (List)Felix_BundleImpl_m_modules_field.get(bundle);
                currentModuleImpl = moduleArray.get(moduleArray.size() - 1);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        if (Felix_ModuleImpl_m_classLoader_field == null && currentModuleImpl != null) {
            try {
                Felix_ModuleImpl_m_classLoader_field = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.ModuleImpl").getDeclaredField("m_classLoader");
                Felix_ModuleImpl_m_classLoader_field.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Throwable)e);
                return null;
            }
            catch (NoSuchFieldException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)Felix_ModuleImpl_m_classLoader_field.get(currentModuleImpl);
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
        try {
            bundle.loadClass("java.lang.Object");
            cl = (ClassLoader)Felix_ModuleImpl_m_classLoader_field.get(currentModuleImpl);
            return cl;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static void initFelix403(Bundle bundle) {
        if (isFelix403 == null) {
            try {
                Class<?> bundleImplClazz = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl");
                Felix_bundleWiringClazz = bundle.getClass().getClassLoader().loadClass("org.osgi.framework.wiring.BundleWiring");
                Felix_adapt_method = bundleImplClazz.getDeclaredMethod("adapt", Class.class);
                Felix_adapt_method.setAccessible(true);
                Felix_bundle_wiring_getClassLoader_method = Felix_bundleWiringClazz.getDeclaredMethod("getClassLoader", new Class[0]);
                Felix_bundle_wiring_getClassLoader_method.setAccessible(true);
                isFelix403 = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Felix 4.x classes not found in environment", new Object[0]);
                isFelix403 = Boolean.FALSE;
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Felix 4.x classes not found in environment", new Object[0]);
                isFelix403 = Boolean.FALSE;
            }
        }
    }

    static {
        isFelix403 = null;
    }
}

