/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.SPDYException;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Flusher {
    private static final Logger LOG = Log.getLogger(Flusher.class);
    private final IteratingCallback iteratingCallback = new SessionIteratingCallback();
    private final Controller controller;
    private final LinkedList<StandardSession.FrameBytes> queue = new LinkedList();
    private Throwable failure;
    private StandardSession.FrameBytes active;
    private boolean flushing;

    public Flusher(Controller controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameBytesFromQueue(Stream stream) {
        LinkedList<StandardSession.FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            for (StandardSession.FrameBytes frameBytes : this.queue) {
                if (frameBytes.getStream() != stream) continue;
                this.queue.remove(frameBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(StandardSession.FrameBytes frameBytes) {
        Throwable failure;
        LinkedList<StandardSession.FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            failure = this.failure;
            if (failure == null) {
                if (frameBytes instanceof StandardSession.ControlFrameBytes) {
                    this.queue.addLast(frameBytes);
                } else {
                    StandardSession.FrameBytes element;
                    int index;
                    for (index = this.queue.size(); index > 0 && (element = this.queue.get(index - 1)).compareTo(frameBytes) < 0; --index) {
                    }
                    this.queue.add(index, frameBytes);
                }
            }
        }
        if (failure == null) {
            this.iteratingCallback.iterate();
        } else {
            frameBytes.failed(new SPDYException(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepend(StandardSession.FrameBytes frameBytes) {
        Throwable failure;
        LinkedList<StandardSession.FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            failure = this.failure;
            if (failure == null) {
                StandardSession.FrameBytes element;
                int index;
                for (index = 0; index < this.queue.size() && (element = this.queue.get(index)).compareTo(frameBytes) > 0; ++index) {
                }
                this.queue.add(index, frameBytes);
            }
        }
        if (failure == null) {
            this.iteratingCallback.iterate();
        } else {
            frameBytes.failed(new SPDYException(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        StandardSession.FrameBytes frameBytes = null;
        ByteBuffer buffer = null;
        boolean failFrameBytes = false;
        LinkedList<StandardSession.FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.flushing || this.queue.isEmpty()) {
                return;
            }
            HashSet<IStream> stalledStreams = null;
            for (int i = 0; i < this.queue.size(); ++i) {
                frameBytes = this.queue.get(i);
                IStream stream = frameBytes.getStream();
                if (stream != null && stalledStreams != null && stalledStreams.contains(stream)) continue;
                buffer = frameBytes.getByteBuffer();
                if (buffer != null) {
                    this.queue.remove(i);
                    if (stream == null || !stream.isReset() || frameBytes instanceof StandardSession.ControlFrameBytes) break;
                    failFrameBytes = true;
                    break;
                }
                if (stalledStreams == null) {
                    stalledStreams = new HashSet<IStream>();
                }
                if (stream != null) {
                    stalledStreams.add(stream);
                }
                LOG.debug("Flush stalled for {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            }
            if (buffer == null) {
                return;
            }
            if (!failFrameBytes) {
                this.flushing = true;
                LOG.debug("Flushing {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            }
        }
        if (failFrameBytes) {
            frameBytes.failed(new StreamException(frameBytes.getStream().getId(), StreamStatus.INVALID_STREAM, "Stream: " + frameBytes.getStream() + " is reset!"));
        } else {
            this.write(buffer, frameBytes);
        }
    }

    private void write(ByteBuffer buffer, StandardSession.FrameBytes frameBytes) {
        this.active = frameBytes;
        if (this.controller != null) {
            LOG.debug("Writing {} frame bytes of {}", new Object[]{buffer.remaining(), buffer.limit()});
            this.controller.write(buffer, (Callback)this.iteratingCallback);
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    private class SessionIteratingCallback
    extends IteratingCallback {
        private SessionIteratingCallback() {
        }

        protected boolean process() throws Exception {
            Flusher.this.flush();
            return false;
        }

        protected void completed() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            LinkedList linkedList;
            if (LOG.isDebugEnabled()) {
                linkedList = Flusher.this.queue;
                synchronized (linkedList) {
                    LOG.debug("Completed write of {}, {} frame(s) in queue", new Object[]{Flusher.this.active, Flusher.this.queue.size()});
                }
            }
            Flusher.this.active.succeeded();
            linkedList = Flusher.this.queue;
            synchronized (linkedList) {
                Flusher.this.flushing = false;
            }
            super.succeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable x) {
            ArrayList frameBytesToFail = new ArrayList();
            LinkedList linkedList = Flusher.this.queue;
            synchronized (linkedList) {
                Flusher.this.failure = x;
                if (LOG.isDebugEnabled()) {
                    String logMessage = String.format("Failed write of %s, failing all %d frame(s) in queue", new Object[]{this, Flusher.this.queue.size()});
                    LOG.debug(logMessage, x);
                }
                frameBytesToFail.addAll(Flusher.this.queue);
                Flusher.this.queue.clear();
            }
            Flusher.this.active.failed(x);
            for (StandardSession.FrameBytes fb : frameBytesToFail) {
                fb.failed(x);
            }
            super.failed(x);
        }
    }
}

