/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.util.AttributesMap;

public class HttpConversation
extends AttributesMap {
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private final HttpClient client;
    private final long id;
    private volatile boolean complete;
    private volatile List<Response.ResponseListener> listeners;

    public HttpConversation(HttpClient client, long id) {
        this.client = client;
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.ResponseListener overrideListener) {
        HttpExchange lastExchange;
        this.complete = overrideListener == null;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>();
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == (lastExchange = this.exchanges.peekLast())) {
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        } else {
            listeners.addAll(lastExchange.getResponseListeners());
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        }
        this.listeners = listeners;
    }

    public void complete() {
        if (this.complete) {
            this.client.removeConversation(this);
        }
    }

    public boolean abort(Throwable cause) {
        HttpExchange exchange = this.exchanges.peekLast();
        return exchange.abort(cause);
    }

    public String toString() {
        return String.format("%s[%d]", HttpConversation.class.getSimpleName(), this.id);
    }
}

