/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final Callback contentCallback = new ContentCallback();
    private final Callback lastCallback = new LastContentCallback();
    private final HttpChannel channel;
    private volatile HttpContent content;

    protected HttpSender(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        block7: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 1: {
                    if (!this.updateSenderState(current, SenderState.SENDING)) continue block7;
                    HttpSender.LOG.debug("Deferred content available, idle -> sending", new Object[0]);
                    content = this.content;
                    content.advance();
                    this.sendContent(exchange, content, this.contentCallback);
                    return;
                }
                case 2: {
                    if (!this.updateSenderState(current, SenderState.SCHEDULED)) continue block7;
                    HttpSender.LOG.debug("Deferred content available, sending -> scheduled", new Object[0]);
                    return;
                }
                case 3: {
                    if (this.updateSenderState(current, SenderState.SCHEDULED)) ** break;
                    continue block7;
                    HttpSender.LOG.debug("Deferred content available, expecting -> scheduled", new Object[0]);
                    return;
                }
                case 4: {
                    HttpSender.LOG.debug("Deferred content available, waiting", new Object[0]);
                    return;
                }
                case 5: {
                    HttpSender.LOG.debug("Deferred content available, scheduled", new Object[0]);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public void send(HttpExchange exchange) {
        Request request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            exchange.abort(cause);
        } else {
            if (!this.queuedToBegin(request)) {
                throw new IllegalStateException();
            }
            if (!this.updateSenderState(SenderState.IDLE, this.expects100Continue(request) ? SenderState.EXPECTING : SenderState.SENDING)) {
                throw new IllegalStateException();
            }
            ContentProvider contentProvider = request.getContent();
            HttpContent content = this.content = new HttpContent(contentProvider);
            if (contentProvider instanceof AsyncContentProvider) {
                ((AsyncContentProvider)contentProvider).setListener(this);
            }
            if (!this.beginToHeaders(request)) {
                return;
            }
            this.sendHeaders(exchange, content, this.commitCallback);
        }
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(Request request) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.BEGIN)) {
            return false;
        }
        LOG.debug("Request begin {}", new Object[]{request});
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyBegin(request);
        return true;
    }

    protected boolean beginToHeaders(Request request) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.HEADERS)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", new Object[]{request, System.getProperty("line.separator"), request.getHeaders().toString().trim()});
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyHeaders(request);
        return true;
    }

    protected boolean headersToCommit(Request request) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.COMMIT)) {
            return false;
        }
        LOG.debug("Request committed {}", new Object[]{request});
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyCommit(request);
        return true;
    }

    protected boolean someToContent(Request request, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                if (!this.updateRequestState(current, RequestState.CONTENT)) {
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", new Object[]{request, System.getProperty("line.separator"), BufferUtil.toDetailString((ByteBuffer)content)});
                }
                RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                notifier.notifyContent(request, content);
                return true;
            }
            case FAILURE: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    protected boolean someToSuccess(HttpExchange exchange) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                boolean completed = exchange.requestComplete();
                if (!completed) {
                    return false;
                }
                this.reset();
                Result result = exchange.terminateRequest(null);
                Request request = exchange.getRequest();
                LOG.debug("Request success {}", new Object[]{request});
                HttpDestination destination = this.getHttpChannel().getHttpDestination();
                destination.getRequestNotifier().notifySuccess(exchange.getRequest());
                if (result != null) {
                    boolean ordered = destination.getHttpClient().isStrictEventOrdering();
                    if (!ordered) {
                        this.channel.exchangeTerminated(result);
                    }
                    LOG.debug("Request/Response succeded {}", new Object[]{request});
                    HttpConversation conversation = exchange.getConversation();
                    destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
                    if (ordered) {
                        this.channel.exchangeTerminated(result);
                    }
                }
                return true;
            }
            case FAILURE: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    protected boolean anyToFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        boolean completed = exchange.requestComplete();
        if (!completed) {
            return false;
        }
        RequestState requestState = this.dispose();
        Result result = exchange.terminateRequest(failure);
        Request request = exchange.getRequest();
        LOG.debug("Request failure {} {}", new Object[]{exchange, failure});
        HttpDestination destination = this.getHttpChannel().getHttpDestination();
        destination.getRequestNotifier().notifyFailure(request, failure);
        boolean notCommitted = this.isBeforeCommit(requestState);
        if (result == null && notCommitted && request.getAbortCause() == null && exchange.responseComplete()) {
            result = exchange.terminateResponse(failure);
            LOG.debug("Failed response from request {}", new Object[]{exchange});
        }
        if (result != null) {
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(result);
            }
            LOG.debug("Request/Response failed {}", new Object[]{request});
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
            if (ordered) {
                this.channel.exchangeTerminated(result);
            }
        }
        return true;
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    protected void reset() {
        this.content = null;
        this.requestState.set(RequestState.QUEUED);
        this.senderState.set(SenderState.IDLE);
    }

    protected RequestState dispose() {
        RequestState current;
        while (!this.updateRequestState(current = this.requestState.get(), RequestState.FAILURE)) {
        }
        return current;
    }

    public void proceed(HttpExchange exchange, boolean proceed) {
        if (!this.expects100Continue(exchange.getRequest())) {
            return;
        }
        if (proceed) {
            block5: while (true) {
                SenderState current = this.senderState.get();
                switch (current) {
                    case EXPECTING: {
                        if (!this.updateSenderState(current, SenderState.SENDING)) continue block5;
                        LOG.debug("Proceed while expecting", new Object[0]);
                        return;
                    }
                    case WAITING: {
                        if (!this.updateSenderState(current, SenderState.SENDING)) continue block5;
                        HttpContent content = this.content;
                        if (content.advance()) {
                            LOG.debug("Proceed while waiting", new Object[0]);
                            this.sendContent(exchange, content, this.contentCallback);
                        } else {
                            if (!this.updateSenderState(SenderState.SENDING, SenderState.IDLE)) continue block5;
                            LOG.debug("Proceed deferred", new Object[0]);
                        }
                        return;
                    }
                    case SCHEDULED: {
                        if (!this.updateSenderState(current, SenderState.WAITING)) {
                            throw new IllegalStateException();
                        }
                        LOG.debug("Proceed while scheduled", new Object[0]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        this.anyToFailure(new HttpRequestException("Expectation failed", exchange.getRequest()));
    }

    public boolean abort(Throwable failure) {
        RequestState current = this.requestState.get();
        boolean abortable = this.isBeforeCommit(current) || this.isSending(current) && !this.content.isLast();
        return abortable && this.anyToFailure(failure);
    }

    protected boolean updateRequestState(RequestState from, RequestState to) {
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{from, to, this.requestState.get()});
        }
        return updated;
    }

    private boolean updateSenderState(SenderState from, SenderState to) {
        boolean updated = this.senderState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{from, to, this.senderState.get()});
        }
        return updated;
    }

    private boolean isBeforeCommit(RequestState requestState) {
        switch (requestState) {
            case QUEUED: 
            case BEGIN: 
            case HEADERS: {
                return true;
            }
        }
        return false;
    }

    private boolean isSending(RequestState requestState) {
        switch (requestState) {
            case COMMIT: 
            case CONTENT: {
                return true;
            }
        }
        return false;
    }

    private class LastContentCallback
    implements Callback {
        private LastContentCallback() {
        }

        public void succeeded() {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpSender.this.someToSuccess(exchange);
        }

        public void failed(Throwable failure) {
            HttpSender.this.anyToFailure(failure);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        /*
         * Unable to fully structure code
         */
        protected boolean process() throws Exception {
            exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return false;
            }
            request = exchange.getRequest();
            content = HttpSender.access$300(HttpSender.this);
            contentBuffer = content.getContent();
            if (contentBuffer != null && !HttpSender.this.someToContent(request, contentBuffer)) {
                return false;
            }
            if (content.advance()) {
                HttpSender.this.sendContent(exchange, content, (Callback)this);
            } else if (content.isConsumed()) {
                HttpSender.this.sendContent(exchange, content, HttpSender.access$600(HttpSender.this));
            } else {
                block4: while (true) {
                    current = (SenderState)HttpSender.access$400(HttpSender.this).get();
                    switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                        case 2: {
                            if (!HttpSender.access$700(HttpSender.this, current, SenderState.IDLE)) continue block4;
                            HttpSender.LOG.debug("Waiting for deferred content for {}", new Object[]{request});
                            return false;
                        }
                        case 5: {
                            if (HttpSender.access$700(HttpSender.this, current, SenderState.SENDING)) ** break;
                            continue block4;
                            HttpSender.LOG.debug("Deferred content available for {}", new Object[]{request});
                            HttpSender.this.sendContent(exchange, content, (Callback)this);
                            return false;
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
            return false;
        }

        protected void completed() {
        }

        public void failed(Throwable failure) {
            super.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        public void succeeded() {
            try {
                this.process();
            }
            catch (Exception x) {
                HttpSender.this.anyToFailure(x);
            }
        }

        private void process() throws Exception {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            Request request = exchange.getRequest();
            if (!HttpSender.this.headersToCommit(request)) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content.hasContent()) {
                ByteBuffer contentBuffer = content.getContent();
                if (contentBuffer != null && !HttpSender.this.someToContent(request, contentBuffer)) {
                    return;
                }
                block5: while (true) {
                    SenderState current = (SenderState)((Object)HttpSender.this.senderState.get());
                    switch (current) {
                        case SENDING: {
                            if (content.advance()) {
                                HttpSender.this.sendContent(exchange, content, HttpSender.this.contentCallback);
                            } else if (content.isConsumed()) {
                                HttpSender.this.sendContent(exchange, content, HttpSender.this.lastCallback);
                            } else {
                                if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block5;
                                LOG.debug("Waiting for deferred content for {}", new Object[]{request});
                            }
                            return;
                        }
                        case EXPECTING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block5;
                            return;
                        }
                        case SCHEDULED: {
                            if (HttpSender.this.expects100Continue(request)) {
                                return;
                            }
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            HttpSender.this.someToSuccess(exchange);
        }

        public void failed(Throwable failure) {
            HttpSender.this.anyToFailure(failure);
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        EXPECTING,
        WAITING,
        SCHEDULED;

    }

    protected static enum RequestState {
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

