/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jasper;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ContainerTldBundleDiscoverer
implements TldBundleDiscoverer {
    public static final String SYS_PROP_TLD_BUNDLES = "org.eclipse.jetty.osgi.tldbundles";

    public URL[] getUrlsForBundlesWithTlds(DeploymentManager deploymentManager, BundleFileLocatorHelper locatorHelper) throws Exception {
        Bundle[] bundles = FrameworkUtil.getBundle(ContainerTldBundleDiscoverer.class).getBundleContext().getBundles();
        HashSet<URL> urls = new HashSet<URL>();
        String tmp = System.getProperty(SYS_PROP_TLD_BUNDLES);
        ArrayList<String> sysNames = new ArrayList<String>();
        if (tmp != null) {
            StringTokenizer tokenizer = new StringTokenizer(tmp, ", \n\r\t", false);
            while (tokenizer.hasMoreTokens()) {
                sysNames.add(tokenizer.nextToken());
            }
        }
        Pattern pattern = (tmp = (String)deploymentManager.getContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern")) == null ? null : Pattern.compile(tmp);
        for (Bundle bundle : bundles) {
            if (sysNames.contains(bundle.getSymbolicName())) {
                this.convertBundleLocationToURL(locatorHelper, bundle, urls);
            }
            if (pattern == null || !pattern.matcher(bundle.getSymbolicName()).matches()) continue;
            this.convertBundleLocationToURL(locatorHelper, bundle, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void convertBundleLocationToURL(BundleFileLocatorHelper locatorHelper, Bundle bundle, Set<URL> urls) throws Exception {
        File jasperLocation = locatorHelper.getBundleInstallLocation(bundle);
        if (jasperLocation.isDirectory()) {
            for (File f : jasperLocation.listFiles()) {
                if (f.getName().endsWith(".jar") && f.isFile()) {
                    urls.add(f.toURI().toURL());
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : jasperLocation.listFiles()) {
                    if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                    urls.add(f2.toURI().toURL());
                }
            }
            urls.add(jasperLocation.toURI().toURL());
        } else {
            urls.add(jasperLocation.toURI().toURL());
        }
    }
}

