/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jasper;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSTLBundleDiscoverer
implements TldBundleDiscoverer {
    private static final Logger LOG = Log.getLogger(JSTLBundleDiscoverer.class);
    private static String DEFAULT_JSTL_BUNDLE_CLASS = "org.apache.taglibs.standard.tag.el.core.WhenTag";
    private static String DEFAULT_JSP_FACTORY_IMPL_CLASS = "org.apache.jasper.runtime.JspFactoryImpl";

    public JSTLBundleDiscoverer() {
        this.fixupDtdResolution();
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
        }
        catch (Exception e) {
            LOG.warn("Unable to locate the JspServlet: jsp support unavailable.", (Throwable)e);
            return;
        }
        try {
            JspFactory fact = JspFactory.getDefaultFactory();
            if (fact == null) {
                fact = (JspFactory)JettyBootstrapActivator.class.getClassLoader().loadClass(DEFAULT_JSP_FACTORY_IMPL_CLASS).newInstance();
                JspFactory.setDefaultFactory((JspFactory)fact);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to set the JspFactory: jsp support incomplete.", (Throwable)e);
        }
    }

    public URL[] getUrlsForBundlesWithTlds(DeploymentManager deployer, BundleFileLocatorHelper locatorHelper) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        HashSet classesToAddToTheTldBundles = new HashSet();
        try {
            Class<?> jstlClass = JSTLBundleDiscoverer.class.getClassLoader().loadClass(DEFAULT_JSTL_BUNDLE_CLASS);
            classesToAddToTheTldBundles.add(jstlClass);
        }
        catch (ClassNotFoundException e) {
            LOG.info("jstl not on classpath", (Throwable)e);
        }
        for (Class clazz : classesToAddToTheTldBundles) {
            Bundle tldBundle = FrameworkUtil.getBundle((Class)clazz);
            File tldBundleLocation = locatorHelper.getBundleInstallLocation(tldBundle);
            if (tldBundleLocation != null && tldBundleLocation.isDirectory()) {
                for (File f : tldBundleLocation.listFiles()) {
                    if (f.getName().endsWith(".jar") && f.isFile()) {
                        urls.add(f.toURI().toURL());
                        continue;
                    }
                    if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                    for (File f2 : tldBundleLocation.listFiles()) {
                        if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                        urls.add(f2.toURI().toURL());
                    }
                }
                continue;
            }
            if (tldBundleLocation == null) continue;
            urls.add(tldBundleLocation.toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    void fixupDtdResolution() {
        try {
            ParserUtils.setEntityResolver((EntityResolver)new MyFixedupEntityResolver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class MyFixedupEntityResolver
    implements EntityResolver {
        static final String[] CACHED_DTD_PUBLIC_IDS = new String[]{"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"};
        static final String[] CACHED_DTD_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", "/javax/servlet/resources/web-app_2_2.dtd", "/javax/servlet/resources/web-app_2_3.dtd"};
        static final String[] CACHED_SCHEMA_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", "/javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", "/javax/servlet/resources/web-app_2_4.xsd", "/javax/servlet/resources/web-app_2_5.xsd"};

        MyFixedupEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            for (int i = 0; i < CACHED_DTD_PUBLIC_IDS.length; ++i) {
                String cachedDtdPublicId = CACHED_DTD_PUBLIC_IDS[i];
                if (!cachedDtdPublicId.equals(publicId)) continue;
                String resourcePath = CACHED_DTD_RESOURCE_PATHS[i];
                InputStream input = null;
                input = Servlet.class.getResourceAsStream(resourcePath);
                if (input == null && (input = JspContext.class.getResourceAsStream(resourcePath)) == null) {
                    input = this.getClass().getResourceAsStream(resourcePath);
                }
                if (input == null) {
                    throw new SAXException(Localizer.getMessage((String)"jsp.error.internal.filenotfound", (String)resourcePath));
                }
                InputSource isrc = new InputSource(input);
                return isrc;
            }
            return null;
        }
    }
}

