/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class AbstractEndPoint
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final long _created = System.currentTimeMillis();
    private final InetSocketAddress _local;
    private final InetSocketAddress _remote;
    private final Scheduler _scheduler;
    private final AtomicReference<Scheduler.Task> _timeout = new AtomicReference();
    private final Runnable _idleTask = new Runnable(){

        @Override
        public void run() {
            long idleLeft = AbstractEndPoint.this.checkIdleTimeout();
            if (idleLeft >= 0L) {
                AbstractEndPoint.this.scheduleIdleTimeout(idleLeft > 0L ? idleLeft : AbstractEndPoint.this.getIdleTimeout());
            }
        }
    };
    private volatile long _idleTimeout;
    private volatile long _idleTimestamp = System.currentTimeMillis();
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(){

        @Override
        protected boolean needsFill() throws IOException {
            return AbstractEndPoint.this.needsFill();
        }
    };
    private final WriteFlusher _writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlushed() {
            AbstractEndPoint.this.onIncompleteFlush();
        }
    };

    protected AbstractEndPoint(Scheduler scheduler, InetSocketAddress local, InetSocketAddress remote) {
        this._local = local;
        this._remote = remote;
        this._scheduler = scheduler;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    @Override
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this._idleTimeout = idleTimeout;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._local;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remote;
    }

    public long getIdleTimestamp() {
        return this._idleTimestamp;
    }

    protected void notIdle() {
        this._idleTimestamp = System.currentTimeMillis();
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    @Override
    public void onOpen() {
        LOG.debug("onOpen {}", new Object[]{this});
    }

    @Override
    public void onClose() {
        LOG.debug("onClose {}", new Object[]{this});
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public <C> void fillInterested(C context, Callback<C> callback) throws IllegalStateException {
        this.notIdle();
        this._fillInterest.register(context, callback);
    }

    @Override
    public <C> void write(C context, Callback<C> callback, ByteBuffer ... buffers) throws IllegalStateException {
        this._writeFlusher.write(context, callback, buffers);
    }

    protected abstract void onIncompleteFlush();

    protected abstract boolean needsFill() throws IOException;

    protected FillInterest getFillInterest() {
        return this._fillInterest;
    }

    protected WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    protected void scheduleIdleTimeout(long delay) {
        Scheduler.Task oldTimeout;
        Scheduler.Task newTimeout = null;
        if (this.isOpen() && delay > 0L && this._scheduler != null) {
            newTimeout = this._scheduler.schedule(this._idleTask, delay, TimeUnit.MILLISECONDS);
        }
        if ((oldTimeout = (Scheduler.Task)this._timeout.getAndSet(newTimeout)) != null) {
            oldTimeout.cancel();
        }
    }

    protected long checkIdleTimeout() {
        if (this.isOpen()) {
            long idleTimestamp = this.getIdleTimestamp();
            long idleTimeout = this.getIdleTimeout();
            long idleElapsed = System.currentTimeMillis() - idleTimestamp;
            long idleLeft = idleTimeout - idleElapsed;
            LOG.debug("{} idle timeout check, elapsed: {} ms, remaining: {} ms", new Object[]{this, idleElapsed, idleLeft});
            if ((this.isOutputShutdown() || this._fillInterest.isInterested() || this._writeFlusher.isInProgress()) && idleTimestamp != 0L && idleTimeout > 0L && idleLeft <= 0L) {
                LOG.debug("{} idle timeout expired", new Object[]{this});
                TimeoutException timeout = new TimeoutException("Idle timeout expired: " + idleElapsed + "/" + idleTimeout + " ms");
                this._fillInterest.onFail(timeout);
                this._writeFlusher.onFail(timeout);
                if (this.isOutputShutdown()) {
                    this.close();
                }
                this.notIdle();
            }
            return idleLeft >= 0L ? idleLeft : 0L;
        }
        return -1L;
    }

    public String toString() {
        return String.format("%s@%x{%s<r-l>%s,o=%b,is=%b,os=%b,fi=%s,wf=%s}{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getRemoteAddress(), this.getLocalAddress(), this.isOpen(), this.isInputShutdown(), this.isOutputShutdown(), this._fillInterest, this._writeFlusher, this.getConnection());
    }
}

