/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadPendingException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;

public abstract class FillInterest {
    private final AtomicBoolean _interested = new AtomicBoolean(false);
    private volatile Callback<Object> _callback;
    private Object _context;

    protected FillInterest() {
    }

    public <C> void register(C context, Callback<C> callback) throws ReadPendingException {
        if (!this._interested.compareAndSet(false, true)) {
            throw new ReadPendingException();
        }
        this._context = context;
        this._callback = callback;
        try {
            if (this.needsFill()) {
                this.fillable();
            }
        }
        catch (IOException e) {
            this.onFail(e);
        }
    }

    public void fillable() {
        if (this._interested.compareAndSet(true, false)) {
            Callback<Object> callback = this._callback;
            Object context = this._context;
            this._callback = null;
            this._context = null;
            callback.completed(context);
        }
    }

    public boolean isInterested() {
        return this._interested.get();
    }

    public void onFail(Throwable cause) {
        if (this._interested.compareAndSet(true, false)) {
            Callback<Object> callback = this._callback;
            Object context = this._context;
            this._callback = null;
            this._context = null;
            callback.failed(context, cause);
        }
    }

    public void onClose() {
        if (this._interested.compareAndSet(true, false)) {
            Callback<Object> callback = this._callback;
            Object context = this._context;
            this._callback = null;
            this._context = null;
            callback.failed(context, (Throwable)new ClosedChannelException());
        }
    }

    public String toString() {
        return String.format("FillInterest@%x{%b,%s,%s}", this.hashCode(), this._interested.get(), this._callback, this._context);
    }

    protected abstract boolean needsFill() throws IOException;
}

