/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.api;

import java.io.IOException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.io.IncomingFrames;
import org.eclipse.jetty.websocket.core.io.OutgoingFrames;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public abstract class Extension
implements OutgoingFrames,
IncomingFrames {
    private Logger LOG = Log.getLogger(this.getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private IncomingFrames nextIncomingFrames;
    private OutgoingFrames nextOutgoingFrames;

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ExtensionConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.config.getName();
    }

    public IncomingFrames getNextIncomingFrames() {
        return this.nextIncomingFrames;
    }

    public OutgoingFrames getNextOutgoingFrames() {
        return this.nextOutgoingFrames;
    }

    public String getParameterizedName() {
        return this.config.getParameterizedName();
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void incoming(WebSocketException e) {
        this.nextIncoming(e);
    }

    @Override
    public void incoming(WebSocketFrame frame) {
        this.nextIncoming(frame);
    }

    public void nextIncoming(WebSocketException e) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextIncoming({}) - {}", new Object[]{e, this.nextIncomingFrames});
        }
        this.nextIncomingFrames.incoming(e);
    }

    public void nextIncoming(WebSocketFrame frame) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextIncoming({}) - {}", new Object[]{frame, this.nextIncomingFrames});
        }
        this.nextIncomingFrames.incoming(frame);
    }

    public <C> void nextOutput(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextOutput({}) - {}", new Object[]{frame, this.nextOutgoingFrames});
        }
        this.nextOutgoingFrames.output(context, callback, frame);
    }

    public <C> void nextOutputNoCallback(WebSocketFrame frame) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("nextOutput({}) - {}", new Object[]{frame, this.nextOutgoingFrames});
        }
        this.nextOutgoingFrames.output(null, new FutureCallback(), frame);
    }

    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        this.nextOutput(context, callback, frame);
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConfig(ExtensionConfig config) {
        this.config = config;
    }

    public void setNextIncomingFrames(IncomingFrames nextIncomingFramesHandler) {
        this.nextIncomingFrames = nextIncomingFramesHandler;
    }

    public void setNextOutgoingFrames(OutgoingFrames nextOutgoingFramesHandler) {
        this.nextOutgoingFrames = nextOutgoingFramesHandler;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public boolean useRsv1() {
        return false;
    }

    public boolean useRsv2() {
        return false;
    }

    public boolean useRsv3() {
        return false;
    }
}

