/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.driver;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.annotations.WebSocket;
import org.eclipse.jetty.websocket.core.api.BaseConnection;
import org.eclipse.jetty.websocket.core.api.CloseException;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.driver.EventMethods;
import org.eclipse.jetty.websocket.core.driver.EventMethodsCache;
import org.eclipse.jetty.websocket.core.io.IncomingFrames;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.io.message.MessageAppender;
import org.eclipse.jetty.websocket.core.io.message.MessageInputStream;
import org.eclipse.jetty.websocket.core.io.message.MessageReader;
import org.eclipse.jetty.websocket.core.io.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.core.io.message.SimpleTextMessage;
import org.eclipse.jetty.websocket.core.protocol.CloseInfo;
import org.eclipse.jetty.websocket.core.protocol.Frame;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class WebSocketEventDriver
implements IncomingFrames {
    private static final Logger LOG = Log.getLogger(WebSocketEventDriver.class);
    private final Logger socketLog;
    private final Object websocket;
    private final WebSocketPolicy policy;
    private final EventMethods events;
    private final ByteBufferPool bufferPool;
    private WebSocketSession session;
    private MessageAppender activeMessage;

    public WebSocketEventDriver(Object websocket, EventMethodsCache methodsCache, WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.websocket = websocket;
        this.events = methodsCache.getMethods(websocket.getClass());
        this.bufferPool = bufferPool;
        this.socketLog = Log.getLogger(websocket.getClass());
        if (this.events.isAnnotated()) {
            WebSocket anno = websocket.getClass().getAnnotation(WebSocket.class);
            if (anno.maxBufferSize() > 0) {
                this.policy.setBufferSize(anno.maxBufferSize());
            }
            if (anno.maxBinarySize() > 0) {
                this.policy.setMaxBinaryMessageSize(anno.maxBinarySize());
            }
            if (anno.maxTextSize() > 0) {
                this.policy.setMaxTextMessageSize(anno.maxTextSize());
            }
            if (anno.maxIdleTime() > 0) {
                this.policy.setIdleTimeout(anno.maxIdleTime());
            }
        }
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Object getWebSocketObject() {
        return this.websocket;
    }

    @Override
    public void incoming(WebSocketException e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.incoming({})", new Object[]{this.websocket.getClass().getSimpleName(), e});
        }
        if (e instanceof CloseException) {
            CloseException close = (CloseException)e;
            this.terminateConnection(close.getStatusCode(), close.getMessage());
        }
        if (this.events.onException != null) {
            this.events.onException.call(this.websocket, this.session, e);
        }
    }

    @Override
    public void incoming(WebSocketFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.onFrame({})", new Object[]{this.websocket.getClass().getSimpleName(), frame});
        }
        if (frame instanceof Frame && this.events.onFrame != null) {
            this.events.onFrame.call(this.websocket, this.session, frame);
        }
        try {
            switch (frame.getOpCode()) {
                case 8: {
                    boolean validate = true;
                    CloseInfo close = new CloseInfo(frame, validate);
                    if (this.events.onClose != null) {
                        this.events.onClose.call(this.websocket, this.session, close.getStatusCode(), close.getReason());
                    }
                    if (this.session.getState() == BaseConnection.State.CLOSING) {
                        this.session.disconnect();
                    } else {
                        this.session.notifyClosing();
                        this.session.close(close.getStatusCode(), close.getReason());
                    }
                    return;
                }
                case 9: {
                    WebSocketFrame pong = new WebSocketFrame(10);
                    if (frame.getPayloadLength() > 0) {
                        ByteBuffer pongBuf = ByteBuffer.allocate(frame.getPayloadLength());
                        BufferUtil.clearToFill((ByteBuffer)pongBuf);
                        BufferUtil.put((ByteBuffer)frame.getPayload(), (ByteBuffer)pongBuf);
                        BufferUtil.flipToFlush((ByteBuffer)pongBuf, (int)0);
                        pong.setPayload(pongBuf);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Pong with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)pongBuf)});
                        }
                    }
                    this.session.output("pong", new FutureCallback(), pong);
                    break;
                }
                case 2: {
                    if (this.events.onBinary == null) {
                        return;
                    }
                    if (this.activeMessage == null) {
                        this.activeMessage = this.events.onBinary.isStreaming() ? new MessageInputStream(this.websocket, this.events.onBinary, this.session, this.bufferPool, this.policy) : new SimpleBinaryMessage(this.websocket, this.events.onBinary, this.session, this.policy);
                    }
                    this.activeMessage.appendMessage(frame.getPayload());
                    if (frame.isFin()) {
                        this.activeMessage.messageComplete();
                        this.activeMessage = null;
                    }
                    return;
                }
                case 1: {
                    if (this.events.onText == null) {
                        return;
                    }
                    if (this.activeMessage == null) {
                        this.activeMessage = this.events.onText.isStreaming() ? new MessageReader(this.websocket, this.events.onBinary, this.session, this.policy) : new SimpleTextMessage(this.websocket, this.events.onText, this.session, this.policy);
                    }
                    this.activeMessage.appendMessage(frame.getPayload());
                    if (frame.isFin()) {
                        this.activeMessage.messageComplete();
                        this.activeMessage = null;
                    }
                    return;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            this.terminateConnection(1007, e.getMessage());
        }
        catch (CloseException e) {
            this.terminateConnection(e.getStatusCode(), e.getMessage());
        }
        catch (Throwable t) {
            this.unhandled(t);
        }
    }

    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.onConnect()", new Object[]{this.websocket.getClass().getSimpleName()});
        }
        this.events.onConnect.call(this.websocket, this.session);
    }

    public void setSession(WebSocketSession conn) {
        this.session = conn;
    }

    private void terminateConnection(int statusCode, String rawreason) {
        String reason = rawreason;
        if (StringUtil.isNotBlank((String)reason) && reason.length() > 123) {
            reason = reason.substring(0, 123);
        }
        LOG.debug("terminateConnection({},{})", new Object[]{statusCode, rawreason});
        this.session.close(statusCode, reason);
    }

    public String toString() {
        return this.websocket.getClass().getName();
    }

    private void unhandled(Throwable t) {
        this.socketLog.warn("Unhandled Error (closing connection)", t);
        switch (this.policy.getBehavior()) {
            case SERVER: {
                this.terminateConnection(1011, t.getClass().getSimpleName());
                break;
            }
            case CLIENT: {
                this.terminateConnection(1008, t.getClass().getSimpleName());
            }
        }
    }
}

