/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.extensions.identity;

import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.websocket.core.api.Extension;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class IdentityExtension
extends Extension {
    private String id;

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        StringBuilder s = new StringBuilder();
        s.append(config.getName());
        s.append("[");
        for (String param : config.getParameterKeys()) {
            s.append(';').append(param).append('=').append(QuotedStringTokenizer.quoteIfNeeded((String)config.getParameter(param, ""), (String)";="));
        }
        s.append("]");
        this.id = s.toString();
    }

    public String toString() {
        return this.id;
    }
}

