/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.extensions.permessage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.BadPayloadException;
import org.eclipse.jetty.websocket.core.api.Extension;
import org.eclipse.jetty.websocket.core.api.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class CompressExtension
extends Extension {
    private static final Logger LOG = Log.getLogger(CompressExtension.class);
    private Deflater deflater;
    private Inflater inflater;

    private void assertSanePayloadLength(int len) {
        if (len > Integer.MAX_VALUE) {
            throw new MessageTooLargeException("[int-sane!] cannot handle payload lengths larger than 2147483647");
        }
        this.getPolicy().assertValidPayloadLength(len);
    }

    public ByteBuffer deflate(ByteBuffer data) {
        int length = data.remaining();
        this.deflater.reset();
        this.deflater.setInput(BufferUtil.toArray((ByteBuffer)data));
        this.deflater.finish();
        ByteBuffer buf = this.getBufferPool().acquire(length, false);
        BufferUtil.clearToFill((ByteBuffer)buf);
        if (length > 65535) {
            buf.put((byte)127);
            buf.put((byte)0);
            buf.put((byte)0);
            buf.put((byte)0);
            buf.put((byte)0);
            buf.put((byte)(length >> 24 & 0xFF));
            buf.put((byte)(length >> 16 & 0xFF));
            buf.put((byte)(length >> 8 & 0xFF));
            buf.put((byte)(length & 0xFF));
        } else if (length >= 126) {
            buf.put((byte)126);
            buf.put((byte)(length >> 8));
            buf.put((byte)(length & 0xFF));
        } else {
            buf.put((byte)(length & 0x7F));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Uncompressed length={} - {}", new Object[]{length, buf.position()});
        }
        while (!this.deflater.finished()) {
            byte[] out = new byte[length];
            int len = this.deflater.deflate(out, 0, length, 3);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deflater: finished={}, needsInput={}, len={} / input.len={}", new Object[]{this.deflater.finished(), this.deflater.needsInput(), len, length});
            }
            buf.put(out, 0, len);
        }
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incoming(WebSocketFrame frame) {
        if (frame.isControlFrame() || !frame.isRsv1()) {
            super.incoming(frame);
            return;
        }
        ByteBuffer data = frame.getPayload();
        try {
            ByteBuffer uncompressed = this.inflate(data);
            frame.setPayload(uncompressed);
            this.nextIncoming(frame);
        }
        finally {
            this.getBufferPool().release(data);
        }
    }

    public ByteBuffer inflate(ByteBuffer data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("inflate: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        int uncompressedLength = this.readUncompresseLength(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("uncompressedLength={}, data={}", new Object[]{uncompressedLength, BufferUtil.toDetailString((ByteBuffer)data)});
        }
        byte[] compressed = BufferUtil.toArray((ByteBuffer)data);
        this.inflater.reset();
        this.inflater.setInput(compressed, 0, compressed.length);
        byte[] buf = new byte[uncompressedLength];
        try {
            int inflated = this.inflater.inflate(buf);
            if (inflated == 0) {
                throw new DataFormatException("Insufficient compressed data");
            }
            ByteBuffer ret = ByteBuffer.wrap(buf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("uncompressed={}", new Object[]{BufferUtil.toDetailString((ByteBuffer)ret)});
            }
            return ret;
        }
        catch (DataFormatException e) {
            LOG.warn((Throwable)e);
            throw new BadPayloadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        if (frame.isControlFrame()) {
            this.nextOutput(context, callback, frame);
            return;
        }
        ByteBuffer data = frame.getPayload();
        try {
            ByteBuffer buf = this.deflate(data);
            frame.setPayload(buf);
            frame.setRsv1(this.deflater.finished());
            this.nextOutput(context, callback, frame);
        }
        finally {
            this.getBufferPool().release(data);
        }
    }

    public int readUncompresseLength(ByteBuffer data) {
        int length = data.get();
        int bytes = 0;
        if (length == 127) {
            length = 0;
            bytes = 8;
        } else if (length == 126) {
            length = 0;
            bytes = 2;
        }
        while (bytes > 0) {
            byte b = data.get();
            length |= (b & 0xFF) << 8 * --bytes;
        }
        this.assertSanePayloadLength(length);
        return length;
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.deflater = new Deflater(9);
        this.deflater.setStrategy(0);
        this.inflater = new Inflater();
    }

    public String toString() {
        return String.format("CompressExtension[]", new Object[0]);
    }

    @Override
    public boolean useRsv1() {
        return true;
    }
}

