/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.core.api.BaseConnection;
import org.eclipse.jetty.websocket.core.api.CloseException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.io.ControlFrameBytes;
import org.eclipse.jetty.websocket.core.io.DataFrameBytes;
import org.eclipse.jetty.websocket.core.io.FrameBytes;
import org.eclipse.jetty.websocket.core.io.FrameQueue;
import org.eclipse.jetty.websocket.core.io.OutgoingFrames;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.protocol.CloseInfo;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;
import org.eclipse.jetty.websocket.core.protocol.Generator;
import org.eclipse.jetty.websocket.core.protocol.Parser;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public abstract class AbstractWebSocketConnection
extends AbstractConnection
implements BaseConnection,
BaseConnection.SuspendToken,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(AbstractWebSocketConnection.class);
    private static final Logger LOG_FRAMES = Log.getLogger((String)"org.eclipse.jetty.websocket.io.Frames");
    private final ByteBufferPool bufferPool;
    private final Scheduler scheduler;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketPolicy policy;
    private final FrameQueue queue;
    private final AtomicBoolean suspendToken;
    private WebSocketSession session;
    private List<ExtensionConfig> extensions;
    private boolean flushing;
    private boolean isFilling;
    private BaseConnection.State connectionState;

    public AbstractWebSocketConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool) {
        super(endp, executor);
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.generator = new Generator(policy, bufferPool);
        this.parser = new Parser(policy);
        this.scheduler = scheduler;
        this.extensions = new ArrayList<ExtensionConfig>();
        this.queue = new FrameQueue();
        this.suspendToken = new AtomicBoolean(false);
        this.connectionState = BaseConnection.State.OPENING;
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        this.enqueClose(statusCode, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> void complete(FrameBytes<C> frameBytes) {
        FrameQueue frameQueue = this.queue;
        synchronized (frameQueue) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completed Write of {} ({} frame(s) in queue)", new Object[]{frameBytes, this.queue.size()});
            }
            this.flushing = false;
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean onlyOutput) {
        this.connectionState = BaseConnection.State.CLOSED;
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", new Object[]{endPoint});
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", new Object[]{endPoint});
            endPoint.close();
        }
    }

    private void enqueClose(int statusCode, String reason) {
        CloseInfo close = new CloseInfo(statusCode, reason);
        FutureCallback nop = new FutureCallback();
        ControlFrameBytes<Object> frameBytes = new ControlFrameBytes<Object>(this, (Callback<Object>)nop, null, close.asFrame());
        this.queue.append(frameBytes);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        FrameBytes frameBytes = null;
        ByteBuffer buffer = null;
        FrameQueue frameQueue = this.queue;
        synchronized (frameQueue) {
            LOG.debug(".flush() - flushing={} - queue.size = {}", new Object[]{this.flushing, this.queue.size()});
            if (this.flushing || this.queue.isEmpty()) {
                return;
            }
            frameBytes = (FrameBytes)this.queue.pop();
            if (!this.isOpen()) {
                this.queue.clear();
                return;
            }
            LOG.debug("Next FrameBytes: {}", new Object[]{frameBytes});
            buffer = frameBytes.getByteBuffer();
            if (buffer == null) {
                return;
            }
            this.flushing = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushing {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            }
            if (this.connectionState != BaseConnection.State.CLOSED) {
                this.write(buffer, frameBytes);
            }
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Parser getParser() {
        return this.parser;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public FrameQueue getQueue() {
        return this.queue;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public BaseConnection.State getState() {
        return this.connectionState;
    }

    @Override
    public boolean isOpen() {
        return this.getState() != BaseConnection.State.CLOSED && this.getEndPoint().isOpen();
    }

    @Override
    public boolean isReading() {
        return this.isFilling;
    }

    @Override
    public void notifyClosing() {
        this.connectionState = BaseConnection.State.CLOSING;
    }

    public void onClose() {
        super.onClose();
        this.connectionState = BaseConnection.State.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFillable() {
        LOG.debug("{} onFillable()", new Object[]{this.policy.getBehavior()});
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear((ByteBuffer)buffer);
        boolean readMore = false;
        try {
            this.isFilling = true;
            readMore = this.read(buffer) != -1;
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (readMore && !this.suspendToken.get()) {
            this.fillInterested();
        } else {
            this.isFilling = false;
        }
    }

    public void onOpen() {
        super.onOpen();
        this.connectionState = BaseConnection.State.OPENED;
        LOG.debug("fillInterested", new Object[0]);
        this.fillInterested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("output({}, {}, {})", new Object[]{context, callback, frame});
        }
        FrameQueue frameQueue = this.queue;
        synchronized (frameQueue) {
            FrameBytes bytes = null;
            bytes = frame.isControlFrame() ? new ControlFrameBytes<C>(this, callback, context, frame) : new DataFrameBytes<C>(this, callback, context, frame);
            this.scheduleTimeout(bytes);
            if (this.isOpen()) {
                if (frame.getOpCode() == 9) {
                    this.queue.prepend(bytes);
                } else {
                    this.queue.append(bytes);
                }
            }
        }
        this.flush();
    }

    private int read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            while (true) {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return 0;
                }
                if (filled < 0) {
                    LOG.debug("read - EOF Reached", new Object[0]);
                    return -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes - {}", new Object[]{filled, BufferUtil.toDetailString((ByteBuffer)buffer)});
                }
                this.parser.parse(buffer);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.enqueClose(1002, e.getMessage());
            return -1;
        }
        catch (CloseException e) {
            LOG.warn((Throwable)e);
            this.enqueClose(e.getStatusCode(), e.getMessage());
            return -1;
        }
    }

    @Override
    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            this.fillInterested();
        }
    }

    private <C> void scheduleTimeout(FrameBytes<C> bytes) {
        if (this.policy.getIdleTimeout() > 0) {
            bytes.task = this.scheduler.schedule(bytes, (long)this.policy.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions = extensions;
    }

    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    @Override
    public BaseConnection.SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    public String toString() {
        return String.format("%s{g=%s,p=%s}", super.toString(), this.generator, this.parser);
    }

    private <C> void write(ByteBuffer buffer, FrameBytes<C> frameBytes) {
        EndPoint endpoint = this.getEndPoint();
        if (LOG_FRAMES.isDebugEnabled()) {
            LOG_FRAMES.debug("{} Writing {} frame bytes of {}", new Object[]{this.policy.getBehavior(), buffer.remaining(), frameBytes});
        }
        if (this.connectionState == BaseConnection.State.CLOSED) {
            return;
        }
        try {
            endpoint.write(frameBytes.context, frameBytes, new ByteBuffer[]{buffer});
        }
        catch (Throwable t) {
            frameBytes.failed(frameBytes.context, t);
        }
    }
}

