/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.BaseConnection;
import org.eclipse.jetty.websocket.core.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.core.io.FrameBytes;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class ControlFrameBytes<C>
extends FrameBytes<C> {
    private static final Logger LOG = Log.getLogger(ControlFrameBytes.class);
    private ByteBuffer buffer;

    public ControlFrameBytes(AbstractWebSocketConnection connection, Callback<C> callback, C context, WebSocketFrame frame) {
        super(connection, callback, context, frame);
    }

    @Override
    public void completed(C context) {
        LOG.debug("completed() - frame: {}", new Object[]{this.frame});
        this.connection.getBufferPool().release(this.buffer);
        super.completed(context);
        if (this.frame.getOpCode() == 8) {
            if (this.connection.getState() == BaseConnection.State.CLOSING) {
                this.connection.disconnect(false);
            } else {
                this.connection.notifyClosing();
            }
        } else {
            this.connection.flush();
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        if (this.buffer == null) {
            this.buffer = this.connection.getGenerator().generate(this.frame);
        }
        return this.buffer;
    }
}

