/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io;

import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.core.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public abstract class FrameBytes<C>
implements Callback<C>,
Runnable {
    private static final Logger LOG = Log.getLogger(FrameBytes.class);
    protected final AbstractWebSocketConnection connection;
    protected final Callback<C> callback;
    protected final C context;
    protected final WebSocketFrame frame;
    protected volatile Scheduler.Task task;

    protected FrameBytes(AbstractWebSocketConnection connection, Callback<C> callback, C context, WebSocketFrame frame) {
        this.connection = connection;
        this.callback = callback;
        this.context = context;
        this.frame = frame;
    }

    private void cancelTask() {
        Scheduler.Task task = this.task;
        if (task != null) {
            task.cancel();
        }
    }

    public void completed(C context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("completed({}) - {}", new Object[]{context, this.getClass().getName()});
        }
        this.cancelTask();
        this.connection.complete(this);
        this.callback.completed(context);
    }

    public void failed(C context, Throwable x) {
        if (x instanceof EofException) {
            LOG.warn("failed(" + context + ") - " + EofException.class, new Object[0]);
        } else {
            LOG.warn("failed(" + context + ")", x);
        }
        this.cancelTask();
        this.callback.failed(context, x);
    }

    public abstract ByteBuffer getByteBuffer();

    @Override
    public void run() {
        this.connection.close();
        this.failed(this.context, new InterruptedByTimeoutException());
    }

    public String toString() {
        return this.frame.toString();
    }
}

