/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io.message;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.driver.EventMethod;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.io.message.MessageAppender;

public class MessageReader
extends Reader
implements MessageAppender {
    private final Object websocket;
    private final EventMethod onEvent;
    private final WebSocketSession session;
    private final WebSocketPolicy policy;
    private final Utf8StringBuilder utf;
    private int size;
    private boolean finished;
    private boolean needsNotification;

    public MessageReader(Object websocket, EventMethod onEvent, WebSocketSession session, WebSocketPolicy policy) {
        this.websocket = websocket;
        this.onEvent = onEvent;
        this.session = session;
        this.policy = policy;
        this.utf = new Utf8StringBuilder();
        this.size = 0;
        this.finished = false;
        this.needsNotification = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendMessage(ByteBuffer payload) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.policy.assertValidTextMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        Utf8StringBuilder utf8StringBuilder = this.utf;
        synchronized (utf8StringBuilder) {
            this.utf.append(payload);
        }
        if (this.needsNotification) {
            this.needsNotification = true;
            this.onEvent.call(this.websocket, this.session, this);
        }
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
    }

    @Override
    public void messageComplete() {
        this.finished = true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return 0;
    }
}

