/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.driver.EventMethod;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.io.message.MessageAppender;

public class SimpleTextMessage
implements MessageAppender {
    private final Object websocket;
    private final EventMethod onEvent;
    private final WebSocketSession session;
    private final WebSocketPolicy policy;
    private final Utf8StringBuilder utf;
    private int size = 0;
    private boolean finished;

    public SimpleTextMessage(Object websocket, EventMethod onEvent, WebSocketSession session, WebSocketPolicy policy) {
        this.websocket = websocket;
        this.onEvent = onEvent;
        this.session = session;
        this.policy = policy;
        this.utf = new Utf8StringBuilder();
        this.size = 0;
        this.finished = false;
    }

    @Override
    public void appendMessage(ByteBuffer payload) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.policy.assertValidTextMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        this.utf.append(payload);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        this.onEvent.call(this.websocket, this.session, this.utf.toString());
    }
}

