/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io.payload;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.core.io.payload.PayloadProcessor;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class DeMaskProcessor
implements PayloadProcessor {
    private boolean isMasked;
    private byte[] mask;
    private int offset;

    @Override
    public void process(ByteBuffer payload) {
        if (!this.isMasked) {
            return;
        }
        int start = payload.position();
        int end = payload.limit();
        int i = start;
        while (i < end) {
            payload.put(i, (byte)(payload.get(i) ^ this.mask[this.offset % 4]));
            ++i;
            ++this.offset;
        }
    }

    @Override
    public void reset(WebSocketFrame frame) {
        this.isMasked = frame.isMasked();
        this.mask = (byte[])(this.isMasked ? frame.getMask() : null);
        this.offset = 0;
    }
}

