/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.websocket.core.api.UpgradeException;
import org.eclipse.jetty.websocket.core.api.UpgradeResponse;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class ServletWebSocketResponse
extends HttpServletResponseWrapper
implements UpgradeResponse {
    private String acceptedProtocol;
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private boolean success = true;

    public ServletWebSocketResponse(HttpServletResponse resp) {
        super(resp);
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
    }

    public String getAcceptedSubProtocol() {
        return this.acceptedProtocol;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Set<String> getHeaderNamesSet() {
        Collection names = this.getHeaderNames();
        return new HashSet<String>(names);
    }

    public String getHeaderValue(String name) {
        return super.getHeader(name);
    }

    public Iterator<String> getHeaderValues(String name) {
        return super.getHeaders(name).iterator();
    }

    public int getStatusCode() {
        throw new UnsupportedOperationException("Server cannot get Status Code");
    }

    public String getStatusReason() {
        throw new UnsupportedOperationException("Server cannot get Status Reason");
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void sendForbidden(String message) throws IOException {
        this.success = false;
        this.sendError(403, message);
    }

    public void setAcceptedSubProtocol(String protocol) {
        this.acceptedProtocol = protocol;
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions = extensions;
    }

    public void validateWebSocketHash(String expectedHash) throws UpgradeException {
        throw new UnsupportedOperationException("Server cannot validate its own hash");
    }
}

