/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.Promise;
import org.eclipse.jetty.spdy.PushSynInfo;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.StandardStream;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.PingInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.SPDYException;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.Settings;
import org.eclipse.jetty.spdy.api.SettingsInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.CredentialFrame;
import org.eclipse.jetty.spdy.frames.DataFrame;
import org.eclipse.jetty.spdy.frames.GoAwayFrame;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.frames.PingFrame;
import org.eclipse.jetty.spdy.frames.RstStreamFrame;
import org.eclipse.jetty.spdy.frames.SettingsFrame;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.spdy.frames.SynStreamFrame;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.Atomics;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ForkInvoker;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class StandardSession
implements ISession,
Parser.Listener,
Callback<FrameBytes>,
Dumpable {
    private static final Logger logger = Log.getLogger(Session.class);
    private final ForkInvoker<Runnable> invoker = new SessionInvoker();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final List<Session.Listener> listeners = new CopyOnWriteArrayList<Session.Listener>();
    private final ConcurrentMap<Integer, IStream> streams = new ConcurrentHashMap<Integer, IStream>();
    private final LinkedList<FrameBytes> queue = new LinkedList();
    private final ByteBufferPool bufferPool;
    private final Executor threadPool;
    private final Scheduler scheduler;
    private final short version;
    private final Controller<FrameBytes> controller;
    private final IdleListener idleListener;
    private final AtomicInteger streamIds;
    private final AtomicInteger pingIds;
    private final SessionFrameListener listener;
    private final Generator generator;
    private final AtomicBoolean goAwaySent = new AtomicBoolean();
    private final AtomicBoolean goAwayReceived = new AtomicBoolean();
    private final AtomicInteger lastStreamId = new AtomicInteger();
    private final FlowControlStrategy flowControlStrategy;
    private boolean flushing;
    private Throwable failure;

    public StandardSession(short version, ByteBufferPool bufferPool, Executor threadPool, Scheduler scheduler, Controller<FrameBytes> controller, IdleListener idleListener, int initialStreamId, SessionFrameListener listener, Generator generator, FlowControlStrategy flowControlStrategy) {
        this.version = version;
        this.bufferPool = bufferPool;
        this.threadPool = threadPool;
        this.scheduler = scheduler;
        this.controller = controller;
        this.idleListener = idleListener;
        this.streamIds = new AtomicInteger(initialStreamId);
        this.pingIds = new AtomicInteger(initialStreamId);
        this.listener = listener;
        this.generator = generator;
        this.flowControlStrategy = flowControlStrategy;
    }

    @Override
    public short getVersion() {
        return this.version;
    }

    @Override
    public void addListener(Session.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Session.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Future<Stream> syn(SynInfo synInfo, StreamFrameListener listener) {
        Promise result = new Promise();
        this.syn(synInfo, listener, 0L, TimeUnit.MILLISECONDS, (Callback<Stream>)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syn(SynInfo synInfo, StreamFrameListener listener, long timeout, TimeUnit unit, Callback<Stream> callback) {
        int associatedStreamId = 0;
        if (synInfo instanceof PushSynInfo) {
            associatedStreamId = ((PushSynInfo)synInfo).getAssociatedStreamId();
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            int streamId = this.streamIds.getAndAdd(2);
            SynStreamFrame synStream = new SynStreamFrame(this.version, synInfo.getFlags(), streamId, associatedStreamId, synInfo.getPriority(), 0, synInfo.getHeaders());
            IStream stream = this.createStream(synStream, listener, true);
            this.generateAndEnqueueControlFrame(stream, synStream, timeout, unit, callback, stream);
        }
        this.flush();
    }

    @Override
    public Future<Void> rst(RstInfo rstInfo) {
        Promise result = new Promise();
        this.rst(rstInfo, 0L, TimeUnit.MILLISECONDS, (Callback<Void>)result);
        return result;
    }

    @Override
    public void rst(RstInfo rstInfo, long timeout, TimeUnit unit, Callback<Void> callback) {
        if (this.goAwaySent.get()) {
            this.complete(callback, null);
        } else {
            int streamId = rstInfo.getStreamId();
            IStream stream = (IStream)this.streams.get(streamId);
            RstStreamFrame frame = new RstStreamFrame(this.version, streamId, rstInfo.getStreamStatus().getCode(this.version));
            this.control(stream, frame, timeout, unit, callback, null);
            if (stream != null) {
                stream.process(frame);
                this.removeStream(stream);
            }
        }
    }

    @Override
    public Future<Void> settings(SettingsInfo settingsInfo) {
        Promise result = new Promise();
        this.settings(settingsInfo, 0L, TimeUnit.MILLISECONDS, (Callback<Void>)result);
        return result;
    }

    @Override
    public void settings(SettingsInfo settingsInfo, long timeout, TimeUnit unit, Callback<Void> callback) {
        SettingsFrame frame = new SettingsFrame(this.version, settingsInfo.getFlags(), settingsInfo.getSettings());
        this.control(null, frame, timeout, unit, callback, null);
    }

    @Override
    public Future<PingInfo> ping() {
        Promise result = new Promise();
        this.ping(0L, TimeUnit.MILLISECONDS, (Callback<PingInfo>)result);
        return result;
    }

    @Override
    public void ping(long timeout, TimeUnit unit, Callback<PingInfo> callback) {
        int pingId = this.pingIds.getAndAdd(2);
        PingInfo pingInfo = new PingInfo(pingId);
        PingFrame frame = new PingFrame(this.version, pingId);
        this.control(null, frame, timeout, unit, callback, pingInfo);
    }

    @Override
    public Future<Void> goAway() {
        return this.goAway(SessionStatus.OK);
    }

    private Future<Void> goAway(SessionStatus sessionStatus) {
        Promise result = new Promise();
        this.goAway(sessionStatus, 0L, TimeUnit.MILLISECONDS, (Callback<Void>)result);
        return result;
    }

    @Override
    public void goAway(long timeout, TimeUnit unit, Callback<Void> callback) {
        this.goAway(SessionStatus.OK, timeout, unit, callback);
    }

    private void goAway(SessionStatus sessionStatus, long timeout, TimeUnit unit, Callback<Void> callback) {
        if (this.goAwaySent.compareAndSet(false, true) && !this.goAwayReceived.get()) {
            GoAwayFrame frame = new GoAwayFrame(this.version, this.lastStreamId.get(), sessionStatus.getCode());
            this.control(null, frame, timeout, unit, callback, null);
            return;
        }
        this.complete(callback, null);
    }

    @Override
    public Set<Stream> getStreams() {
        HashSet<Stream> result = new HashSet<Stream>();
        result.addAll(this.streams.values());
        return result;
    }

    @Override
    public IStream getStream(int streamId) {
        return (IStream)this.streams.get(streamId);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onControlFrame(ControlFrame frame) {
        this.notifyIdle(this.idleListener, false);
        try {
            logger.debug("Processing {}", new Object[]{frame});
            if (this.goAwaySent.get()) {
                logger.debug("Skipped processing of {}", new Object[]{frame});
                return;
            }
            switch (frame.getType()) {
                case SYN_STREAM: {
                    this.onSyn((SynStreamFrame)frame);
                    return;
                }
                case SYN_REPLY: {
                    this.onReply((SynReplyFrame)frame);
                    return;
                }
                case RST_STREAM: {
                    this.onRst((RstStreamFrame)frame);
                    return;
                }
                case SETTINGS: {
                    this.onSettings((SettingsFrame)frame);
                    return;
                }
                case NOOP: {
                    return;
                }
                case PING: {
                    this.onPing((PingFrame)frame);
                    return;
                }
                case GO_AWAY: {
                    this.onGoAway((GoAwayFrame)frame);
                    return;
                }
                case HEADERS: {
                    this.onHeaders((HeadersFrame)frame);
                    return;
                }
                case WINDOW_UPDATE: {
                    this.onWindowUpdate((WindowUpdateFrame)frame);
                    return;
                }
                case CREDENTIAL: {
                    this.onCredential((CredentialFrame)frame);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.notifyIdle(this.idleListener, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataFrame(DataFrame frame, ByteBuffer data) {
        this.notifyIdle(this.idleListener, false);
        try {
            logger.debug("Processing {}, {} data bytes", new Object[]{frame, data.remaining()});
            if (this.goAwaySent.get()) {
                logger.debug("Skipped processing of {}", new Object[]{frame});
                return;
            }
            int streamId = frame.getStreamId();
            IStream stream = (IStream)this.streams.get(streamId);
            if (stream == null) {
                RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
                logger.debug("Unknown stream {}", new Object[]{rstInfo});
                this.rst(rstInfo);
            } else {
                this.processData(stream, frame, data);
            }
        }
        finally {
            this.notifyIdle(this.idleListener, true);
        }
    }

    private void notifyIdle(IdleListener listener, boolean idle) {
        if (listener != null) {
            listener.onIdle(idle);
        }
    }

    private void processData(final IStream stream, DataFrame frame, ByteBuffer data) {
        ByteBufferDataInfo dataInfo = new ByteBufferDataInfo(data, frame.isClose(), frame.isCompress()){

            @Override
            public void consume(int delta) {
                super.consume(delta);
                StandardSession.this.flowControlStrategy.onDataConsumed(StandardSession.this, stream, this, delta);
            }
        };
        this.flowControlStrategy.onDataReceived(this, stream, dataInfo);
        stream.process(dataInfo);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    @Override
    public void onStreamException(StreamException x) {
        this.notifyOnException(this.listener, x);
        this.rst(new RstInfo(x.getStreamId(), x.getStreamStatus()));
    }

    @Override
    public void onSessionException(SessionException x) {
        Throwable cause = x.getCause();
        this.notifyOnException(this.listener, cause == null ? x : cause);
        this.goAway(x.getSessionStatus());
    }

    private void onSyn(SynStreamFrame frame) {
        IStream stream = this.createStream(frame, null, false);
        if (stream != null) {
            this.processSyn(this.listener, stream, frame);
        }
    }

    private void processSyn(SessionFrameListener listener, IStream stream, SynStreamFrame frame) {
        stream.process(frame);
        this.updateLastStreamId(stream);
        SynInfo synInfo = new SynInfo(frame.getHeaders(), frame.isClose(), frame.getPriority());
        StreamFrameListener streamListener = this.notifyOnSyn(listener, stream, synInfo);
        stream.setStreamFrameListener(streamListener);
        this.flush();
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private IStream createStream(SynStreamFrame frame, StreamFrameListener listener, boolean local) {
        int streamId;
        IStream stream = this.newStream(frame);
        stream.updateCloseState(frame.isClose(), local);
        stream.setStreamFrameListener(listener);
        if (stream.isUnidirectional()) {
            stream.updateCloseState(true, !local);
            if (!stream.isClosed()) {
                stream.getAssociatedStream().associate(stream);
            }
        }
        if (this.streams.putIfAbsent(streamId = stream.getId(), stream) != null) {
            if (local) {
                throw new IllegalStateException("Duplicate stream id " + streamId);
            }
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.PROTOCOL_ERROR);
            logger.debug("Duplicate stream, {}", new Object[]{rstInfo});
            this.rst(rstInfo);
            return null;
        }
        logger.debug("Created {}", new Object[]{stream});
        if (local) {
            this.notifyStreamCreated(stream);
        }
        return stream;
    }

    private IStream newStream(SynStreamFrame frame) {
        IStream associatedStream = (IStream)this.streams.get(frame.getAssociatedStreamId());
        StandardStream stream = new StandardStream(frame.getStreamId(), frame.getPriority(), this, associatedStream);
        this.flowControlStrategy.onNewStream(this, stream);
        return stream;
    }

    private void notifyStreamCreated(IStream stream) {
        for (Session.Listener listener : this.listeners) {
            if (!(listener instanceof Session.StreamListener)) continue;
            try {
                ((Session.StreamListener)listener).onStreamCreated(stream);
            }
            catch (Exception x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
            }
            catch (Error x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
                throw x;
            }
        }
    }

    private void removeStream(IStream stream) {
        IStream removed;
        if (stream.isUnidirectional()) {
            stream.getAssociatedStream().disassociate(stream);
        }
        if ((removed = (IStream)this.streams.remove(stream.getId())) != null) assert (removed == stream);
        logger.debug("Removed {}", new Object[]{stream});
        this.notifyStreamClosed(stream);
    }

    private void notifyStreamClosed(IStream stream) {
        for (Session.Listener listener : this.listeners) {
            if (!(listener instanceof Session.StreamListener)) continue;
            try {
                ((Session.StreamListener)listener).onStreamClosed(stream);
            }
            catch (Exception x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
            }
            catch (Error x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
                throw x;
            }
        }
    }

    private void onReply(SynReplyFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream == null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
            logger.debug("Unknown stream {}", new Object[]{rstInfo});
            this.rst(rstInfo);
        } else {
            this.processReply(stream, frame);
        }
    }

    private void processReply(IStream stream, SynReplyFrame frame) {
        stream.process(frame);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private void onRst(RstStreamFrame frame) {
        IStream stream = (IStream)this.streams.get(frame.getStreamId());
        if (stream != null) {
            stream.process(frame);
        }
        RstInfo rstInfo = new RstInfo(frame.getStreamId(), StreamStatus.from(frame.getVersion(), frame.getStatusCode()));
        this.notifyOnRst(this.listener, rstInfo);
        this.flush();
        if (stream != null) {
            this.removeStream(stream);
        }
    }

    private void onSettings(SettingsFrame frame) {
        Settings.Setting windowSizeSetting = frame.getSettings().get(Settings.ID.INITIAL_WINDOW_SIZE);
        if (windowSizeSetting != null) {
            int windowSize = windowSizeSetting.value();
            this.setWindowSize(windowSize);
            logger.debug("Updated session window size to {}", new Object[]{windowSize});
        }
        SettingsInfo settingsInfo = new SettingsInfo(frame.getSettings(), frame.isClearPersisted());
        this.notifyOnSettings(this.listener, settingsInfo);
        this.flush();
    }

    private void onPing(PingFrame frame) {
        int pingId = frame.getPingId();
        if (pingId % 2 == this.pingIds.get() % 2) {
            PingInfo pingInfo = new PingInfo(frame.getPingId());
            this.notifyOnPing(this.listener, pingInfo);
            this.flush();
        } else {
            this.control(null, frame, 0L, TimeUnit.MILLISECONDS, null, null);
        }
    }

    private void onGoAway(GoAwayFrame frame) {
        if (this.goAwayReceived.compareAndSet(false, true)) {
            GoAwayInfo goAwayInfo = new GoAwayInfo(frame.getLastStreamId(), SessionStatus.from(frame.getStatusCode()));
            this.notifyOnGoAway(this.listener, goAwayInfo);
            this.flush();
        }
    }

    private void onHeaders(HeadersFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream == null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
            logger.debug("Unknown stream, {}", new Object[]{rstInfo});
            this.rst(rstInfo);
        } else {
            this.processHeaders(stream, frame);
        }
    }

    private void processHeaders(IStream stream, HeadersFrame frame) {
        stream.process(frame);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private void onWindowUpdate(WindowUpdateFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        this.flowControlStrategy.onWindowUpdate(this, stream, frame.getWindowDelta());
        this.flush();
    }

    private void onCredential(CredentialFrame frame) {
        logger.warn("{} frame not yet supported", new Object[]{frame.getType()});
        this.flush();
    }

    protected void close() {
        if (this.controller != null) {
            this.controller.close(false);
        }
    }

    private void notifyOnException(SessionFrameListener listener, Throwable x) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{x, listener});
                listener.onException(x);
            }
        }
        catch (Exception xx) {
            logger.info("Exception while notifying listener " + listener, (Throwable)xx);
        }
        catch (Error xx) {
            logger.info("Exception while notifying listener " + listener, (Throwable)xx);
            throw xx;
        }
    }

    private StreamFrameListener notifyOnSyn(SessionFrameListener listener, Stream stream, SynInfo synInfo) {
        try {
            if (listener == null) {
                return null;
            }
            logger.debug("Invoking callback with {} on listener {}", new Object[]{synInfo, listener});
            return listener.onSyn(stream, synInfo);
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
            return null;
        }
        catch (Error x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    private void notifyOnRst(SessionFrameListener listener, RstInfo rstInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{rstInfo, listener});
                listener.onRst(this, rstInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    private void notifyOnSettings(SessionFrameListener listener, SettingsInfo settingsInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{settingsInfo, listener});
                listener.onSettings(this, settingsInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    private void notifyOnPing(SessionFrameListener listener, PingInfo pingInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{pingInfo, listener});
                listener.onPing(this, pingInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    private void notifyOnGoAway(SessionFrameListener listener, GoAwayInfo goAwayInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{goAwayInfo, listener});
                listener.onGoAway(this, goAwayInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    @Override
    public <C> void control(IStream stream, ControlFrame frame, long timeout, TimeUnit unit, Callback<C> callback, C context) {
        this.generateAndEnqueueControlFrame(stream, frame, timeout, unit, callback, context);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C> void generateAndEnqueueControlFrame(IStream stream, ControlFrame frame, long timeout, TimeUnit unit, Callback<C> callback, C context) {
        try {
            StandardSession standardSession = this;
            synchronized (standardSession) {
                ByteBuffer buffer = this.generator.control(frame);
                logger.debug("Queuing {} on {}", new Object[]{frame, stream});
                ControlFrameBytes frameBytes = new ControlFrameBytes(stream, callback, context, frame, buffer);
                if (timeout > 0L) {
                    frameBytes.task = this.scheduler.schedule(frameBytes, timeout, unit);
                }
                if (ControlFrameType.PING == frame.getType()) {
                    this.prepend(frameBytes);
                } else {
                    this.append(frameBytes);
                }
            }
        }
        catch (Exception x) {
            this.notifyCallbackFailed(callback, context, x);
        }
    }

    private void updateLastStreamId(IStream stream) {
        int streamId = stream.getId();
        if (streamId % 2 != this.streamIds.get() % 2) {
            Atomics.updateMax((AtomicInteger)this.lastStreamId, (int)streamId);
        }
    }

    @Override
    public <C> void data(IStream stream, DataInfo dataInfo, long timeout, TimeUnit unit, Callback<C> callback, C context) {
        logger.debug("Queuing {} on {}", new Object[]{dataInfo, stream});
        DataFrameBytes frameBytes = new DataFrameBytes(stream, callback, context, dataInfo);
        if (timeout > 0L) {
            frameBytes.task = this.scheduler.schedule(frameBytes, timeout, unit);
        }
        this.append(frameBytes);
        this.flush();
    }

    @Override
    public void shutdown() {
        CloseFrameBytes frameBytes = new CloseFrameBytes();
        this.append(frameBytes);
        this.flush();
    }

    private void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        FrameBytes frameBytes = null;
        ByteBuffer buffer = null;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.flushing || this.queue.isEmpty()) {
                return;
            }
            HashSet<IStream> stalledStreams = null;
            for (int i = 0; i < this.queue.size(); ++i) {
                frameBytes = this.queue.get(i);
                IStream stream = frameBytes.getStream();
                if (stream != null && stalledStreams != null && stalledStreams.contains(stream)) continue;
                buffer = frameBytes.getByteBuffer();
                if (buffer != null) {
                    this.queue.remove(i);
                    if (stream == null || !stream.isReset()) break;
                    frameBytes.fail(new StreamException(stream.getId(), StreamStatus.INVALID_STREAM, "Stream: " + stream + " is reset!"));
                    return;
                }
                if (stalledStreams == null) {
                    stalledStreams = new HashSet<IStream>();
                }
                if (stream != null) {
                    stalledStreams.add(stream);
                }
                logger.debug("Flush stalled for {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            }
            if (buffer == null) {
                return;
            }
            this.flushing = true;
            logger.debug("Flushing {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
        }
        this.write(buffer, this, frameBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(FrameBytes frameBytes) {
        Throwable failure;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            failure = this.failure;
            if (failure == null) {
                FrameBytes element;
                int index;
                for (index = this.queue.size(); index > 0 && (element = this.queue.get(index - 1)).compareTo(frameBytes) < 0; --index) {
                }
                this.queue.add(index, frameBytes);
            }
        }
        if (failure != null) {
            frameBytes.fail(new SPDYException(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepend(FrameBytes frameBytes) {
        Throwable failure;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            failure = this.failure;
            if (failure == null) {
                FrameBytes element;
                int index;
                for (index = 0; index < this.queue.size() && (element = this.queue.get(index)).compareTo(frameBytes) > 0; ++index) {
                }
                this.queue.add(index, frameBytes);
            }
        }
        if (failure != null) {
            frameBytes.fail(new SPDYException(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(FrameBytes frameBytes) {
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            logger.debug("Completed write of {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            this.flushing = false;
        }
        frameBytes.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(FrameBytes frameBytes, Throwable x) {
        ArrayList<FrameBytes> frameBytesToFail = new ArrayList<FrameBytes>();
        frameBytesToFail.add(frameBytes);
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            this.failure = x;
            String logMessage = String.format("Failed write of %s, failing all %d frame(s) in queue", frameBytes, this.queue.size());
            logger.debug(logMessage, x);
            frameBytesToFail.addAll(this.queue);
            this.queue.clear();
            this.flushing = false;
        }
        for (FrameBytes fb : frameBytesToFail) {
            fb.fail(x);
        }
    }

    protected void write(ByteBuffer buffer, Callback<FrameBytes> callback, FrameBytes frameBytes) {
        if (this.controller != null) {
            logger.debug("Writing {} frame bytes of {}", new Object[]{buffer.remaining(), frameBytes});
            this.controller.write(buffer, callback, frameBytes);
        }
    }

    private <C> void complete(final Callback<C> callback, final C context) {
        this.invoker.invoke((Object)new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    StandardSession.this.notifyCallbackCompleted(callback, context);
                }
                StandardSession.this.flush();
            }
        });
    }

    private <C> void notifyCallbackCompleted(Callback<C> callback, C context) {
        try {
            callback.completed(context);
        }
        catch (Exception x) {
            logger.info("Exception while notifying callback " + callback, (Throwable)x);
        }
        catch (Error x) {
            logger.info("Exception while notifying callback " + callback, (Throwable)x);
            throw x;
        }
    }

    private <C> void notifyCallbackFailed(Callback<C> callback, C context, Throwable x) {
        try {
            if (callback != null) {
                callback.failed(context, x);
            }
        }
        catch (Exception xx) {
            logger.info("Exception while notifying callback " + callback, (Throwable)xx);
        }
        catch (Error xx) {
            logger.info("Exception while notifying callback " + callback, (Throwable)xx);
            throw xx;
        }
    }

    public int getWindowSize() {
        return this.flowControlStrategy.getWindowSize(this);
    }

    public void setWindowSize(int initialWindowSize) {
        this.flowControlStrategy.setWindowSize(this, initialWindowSize);
    }

    public String toString() {
        return String.format("%s@%x{v%d,queuSize=%d,windowSize=%d,streams=%d}", this.getClass().getSimpleName(), this.hashCode(), this.version, this.queue.size(), this.getWindowSize(), this.streams.size());
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)this);
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singletonList(this.controller), this.streams.values()});
    }

    private class CloseFrameBytes
    extends AbstractFrameBytes<Void> {
        private CloseFrameBytes() {
            super((IStream)null, new Callback.Empty(), null);
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return BufferUtil.EMPTY_BUFFER;
        }

        @Override
        public void complete() {
            super.complete();
            StandardSession.this.close();
        }
    }

    private class DataFrameBytes<C>
    extends AbstractFrameBytes<C> {
        private final DataInfo dataInfo;
        private int size;
        private volatile ByteBuffer buffer;

        private DataFrameBytes(IStream stream, Callback<C> handler, C context, DataInfo dataInfo) {
            super(stream, handler, context);
            this.dataInfo = dataInfo;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            try {
                IStream stream = this.getStream();
                int windowSize = stream.getWindowSize();
                if (windowSize <= 0) {
                    return null;
                }
                this.size = this.dataInfo.available();
                if (this.size > windowSize) {
                    this.size = windowSize;
                }
                this.buffer = StandardSession.this.generator.data(stream.getId(), this.size, this.dataInfo);
                return this.buffer;
            }
            catch (Throwable x) {
                this.fail(x);
                return null;
            }
        }

        @Override
        public void complete() {
            StandardSession.this.bufferPool.release(this.buffer);
            IStream stream = this.getStream();
            StandardSession.this.flowControlStrategy.updateWindow(StandardSession.this, stream, -this.size);
            if (this.dataInfo.available() > 0) {
                StandardSession.this.prepend(this);
                StandardSession.this.flush();
            } else {
                super.complete();
                stream.updateCloseState(this.dataInfo.isClose(), true);
                if (stream.isClosed()) {
                    StandardSession.this.removeStream(stream);
                }
            }
        }

        public String toString() {
            return String.format("DATA bytes @%x available=%d consumed=%d on %s", this.dataInfo.hashCode(), this.dataInfo.available(), this.dataInfo.consumed(), this.getStream());
        }
    }

    private class ControlFrameBytes<C>
    extends AbstractFrameBytes<C> {
        private final ControlFrame frame;
        private final ByteBuffer buffer;

        private ControlFrameBytes(IStream stream, Callback<C> callback, C context, ControlFrame frame, ByteBuffer buffer) {
            super(stream, callback, context);
            this.frame = frame;
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.buffer;
        }

        @Override
        public void complete() {
            IStream stream;
            StandardSession.this.bufferPool.release(this.buffer);
            super.complete();
            if (this.frame.getType() == ControlFrameType.GO_AWAY) {
                StandardSession.this.close();
            }
            if ((stream = this.getStream()) != null && stream.isClosed()) {
                StandardSession.this.removeStream(stream);
            }
        }

        public String toString() {
            return this.frame.toString();
        }
    }

    private abstract class AbstractFrameBytes<C>
    implements FrameBytes,
    Runnable {
        private final IStream stream;
        private final Callback<C> callback;
        private final C context;
        protected volatile Scheduler.Task task;

        protected AbstractFrameBytes(IStream stream, Callback<C> callback, C context) {
            this.stream = stream;
            this.callback = callback;
            this.context = context;
        }

        @Override
        public IStream getStream() {
            return this.stream;
        }

        @Override
        public int compareTo(FrameBytes that) {
            IStream thisStream = this.getStream();
            IStream thatStream = that.getStream();
            if (thisStream == null) {
                return thatStream == null ? 0 : -1;
            }
            if (thatStream == null) {
                return 1;
            }
            return thatStream.getPriority() - thisStream.getPriority();
        }

        @Override
        public void complete() {
            this.cancelTask();
            StandardSession.this.complete(this.callback, this.context);
        }

        @Override
        public void fail(Throwable x) {
            this.cancelTask();
            StandardSession.this.notifyCallbackFailed(this.callback, this.context, x);
            StandardSession.this.flush();
        }

        private void cancelTask() {
            Scheduler.Task task = this.task;
            if (task != null) {
                task.cancel();
            }
        }

        @Override
        public void run() {
            StandardSession.this.close();
            this.fail(new InterruptedByTimeoutException());
        }
    }

    public static interface FrameBytes
    extends Comparable<FrameBytes> {
        public IStream getStream();

        public ByteBuffer getByteBuffer();

        public void complete();

        public void fail(Throwable var1);
    }

    private class SessionInvoker
    extends ForkInvoker<Runnable> {
        private SessionInvoker() {
            super(4);
        }

        public void fork(Runnable task) {
            StandardSession.this.execute(task);
        }

        public void call(Runnable task) {
            task.run();
        }
    }
}

