/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.api.DataInfo;

public class BytesDataInfo
extends DataInfo {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private int index;

    public BytesDataInfo(byte[] bytes, boolean close) {
        this(bytes, 0, bytes.length, close);
    }

    public BytesDataInfo(byte[] bytes, int offset, int length, boolean close) {
        super(close, false);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.index = offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int available() {
        return this.length - this.index + this.offset;
    }

    @Override
    public int readInto(ByteBuffer output) {
        int space = output.remaining();
        int chunk = Math.min(this.available(), space);
        output.put(this.bytes, this.index, chunk);
        this.index += chunk;
        return chunk;
    }

    @Override
    public int readInto(byte[] bytes, int offset, int length) {
        int chunk = Math.min(this.available(), length);
        System.arraycopy(this.bytes, this.index, bytes, offset, chunk);
        this.index += chunk;
        return chunk;
    }
}

