/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.http.HttpChannelOverSPDY;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpTransportOverSPDY
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverSPDY.class);
    private final Connector connector;
    private final HttpConfiguration configuration;
    private final EndPoint endPoint;
    private final PushStrategy pushStrategy;
    private final Stream stream;
    private final Fields requestHeaders;
    private final BlockingCallback streamBlocker = new BlockingCallback();

    public HttpTransportOverSPDY(Connector connector, HttpConfiguration configuration, EndPoint endPoint, PushStrategy pushStrategy, Stream stream, Fields requestHeaders) {
        this.connector = connector;
        this.configuration = configuration;
        this.endPoint = endPoint;
        this.pushStrategy = pushStrategy;
        this.stream = stream;
        this.requestHeaders = requestHeaders;
    }

    public <C> void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, C context, Callback<C> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("send  {} {} {} {} last={}%n", new Object[]{this, this.stream, info, BufferUtil.toDetailString((ByteBuffer)content), lastContent});
        }
        if (this.stream.isClosed() || this.stream.isReset()) {
            callback.failed(context, (Throwable)new EofException("stream closed"));
            return;
        }
        boolean hasContent = BufferUtil.hasContent((ByteBuffer)content);
        if (info != null) {
            short version = this.stream.getSession().getVersion();
            Fields headers = new Fields();
            HttpVersion httpVersion = HttpVersion.HTTP_1_1;
            headers.put(HTTPSPDYHeader.VERSION.name(version), httpVersion.asString());
            int status = info.getStatus();
            StringBuilder httpStatus = new StringBuilder().append(status);
            String reason = info.getReason();
            if (reason == null) {
                reason = HttpStatus.getMessage((int)status);
            }
            if (reason != null) {
                httpStatus.append(" ").append(reason);
            }
            headers.put(HTTPSPDYHeader.STATUS.name(version), httpStatus.toString());
            LOG.debug("HTTP < {} {}", new Object[]{httpVersion, httpStatus});
            HttpFields fields = info.getHttpFields();
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    HttpFields.Field field = fields.getField(i);
                    String name = field.getName();
                    String value = field.getValue();
                    headers.put(name, value);
                    LOG.debug("HTTP < {}: {}", new Object[]{name, value});
                }
            }
            boolean close = !hasContent && lastContent;
            ReplyInfo reply = new ReplyInfo(headers, close);
            this.reply(this.stream, reply);
        }
        if (hasContent) {
            if (this.stream.isClosed() || this.stream.isReset()) {
                callback.failed(context, (Throwable)new EofException("stream closed"));
            } else {
                this.stream.data((DataInfo)new ByteBufferDataInfo(content, lastContent), this.endPoint.getIdleTimeout(), TimeUnit.MILLISECONDS, context, callback);
            }
        } else if (lastContent) {
            if (this.stream.isClosed() || this.stream.isReset()) {
                callback.completed(context);
            } else {
                this.stream.data((DataInfo)new ByteBufferDataInfo(BufferUtil.EMPTY_BUFFER, lastContent), this.endPoint.getIdleTimeout(), TimeUnit.MILLISECONDS, context, callback);
            }
        } else {
            callback.completed(context);
        }
    }

    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent) throws IOException {
        this.send(info, content, lastContent, (Object)this.streamBlocker.getPhase(), (Callback)this.streamBlocker);
        try {
            this.streamBlocker.block();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EofException((Throwable)e);
        }
    }

    public void completed() {
        LOG.debug("completed", new Object[0]);
    }

    private void reply(Stream stream, ReplyInfo replyInfo) {
        short version;
        Fields responseHeaders;
        if (!stream.isUnidirectional()) {
            stream.reply(replyInfo);
        }
        if ((responseHeaders = replyInfo.getHeaders()).get(HTTPSPDYHeader.STATUS.name(version = stream.getSession().getVersion())).value().startsWith("200") && !stream.isClosed()) {
            Fields.Field scheme = this.requestHeaders.get(HTTPSPDYHeader.SCHEME.name(version));
            Fields.Field host = this.requestHeaders.get(HTTPSPDYHeader.HOST.name(version));
            Fields.Field uri = this.requestHeaders.get(HTTPSPDYHeader.URI.name(version));
            Set<String> pushResources = this.pushStrategy.apply(stream, this.requestHeaders, responseHeaders);
            for (String pushResource : pushResources) {
                Fields pushHeaders = this.createPushHeaders(scheme, host, pushResource);
                final Fields pushRequestHeaders = this.createRequestHeaders(scheme, host, uri, pushResource);
                stream.syn(new SynInfo(pushHeaders, false), 0L, TimeUnit.MILLISECONDS, (Callback)new Callback.Empty<Stream>(){

                    public void completed(Stream pushStream) {
                        HttpChannelOverSPDY pushChannel = HttpTransportOverSPDY.this.newHttpChannelOverSPDY(pushStream, pushRequestHeaders);
                        pushChannel.requestStart(pushRequestHeaders, true);
                    }
                });
            }
        }
    }

    private Fields createRequestHeaders(Fields.Field scheme, Fields.Field host, Fields.Field uri, String pushResourcePath) {
        Fields requestHeaders = new Fields();
        short version = this.stream.getSession().getVersion();
        requestHeaders.put(HTTPSPDYHeader.METHOD.name(version), "GET");
        requestHeaders.put(HTTPSPDYHeader.VERSION.name(version), "HTTP/1.1");
        requestHeaders.put(scheme);
        requestHeaders.put(host);
        requestHeaders.put(HTTPSPDYHeader.URI.name(version), pushResourcePath);
        String referrer = scheme.value() + "://" + host.value() + uri.value();
        requestHeaders.put("referer", referrer);
        requestHeaders.put(requestHeaders.get("accept-encoding"));
        requestHeaders.put("x-spdy-push", "true");
        return requestHeaders;
    }

    private Fields createPushHeaders(Fields.Field scheme, Fields.Field host, String pushResourcePath) {
        Fields pushHeaders = new Fields();
        short version = this.stream.getSession().getVersion();
        if (version == 2) {
            pushHeaders.put(HTTPSPDYHeader.URI.name(version), scheme.value() + "://" + host.value() + pushResourcePath);
        } else {
            pushHeaders.put(HTTPSPDYHeader.URI.name(version), pushResourcePath);
            pushHeaders.put(scheme);
            pushHeaders.put(host);
        }
        pushHeaders.put(HTTPSPDYHeader.STATUS.name(version), "200");
        pushHeaders.put(HTTPSPDYHeader.VERSION.name(version), "HTTP/1.1");
        return pushHeaders;
    }

    private HttpChannelOverSPDY newHttpChannelOverSPDY(Stream pushStream, Fields pushRequestHeaders) {
        HttpTransportOverSPDY transport = new HttpTransportOverSPDY(this.connector, this.configuration, this.endPoint, this.pushStrategy, pushStream, pushRequestHeaders);
        HttpInputOverSPDY input = new HttpInputOverSPDY();
        return new HttpChannelOverSPDY(this.connector, this.configuration, this.endPoint, transport, input, pushStream);
    }
}

