/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.fragment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

public class FragmentExtension
extends AbstractExtension {
    private int maxLength = -1;

    @Override
    public void incomingError(WebSocketException e) {
        this.nextIncomingError(e);
    }

    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    public Future<SendResult> outgoingFrame(Frame frame) throws IOException {
        WebSocketFrame frag;
        if (frame.getType().isControl()) {
            return this.nextOutgoingFrame(frame);
        }
        byte opcode = frame.getType().getOpCode();
        ByteBuffer payload = frame.getPayload().slice();
        int originalLimit = payload.limit();
        int currentPosition = payload.position();
        if (this.maxLength <= 0) {
            return this.nextOutgoingFrame(frame);
        }
        boolean continuation = false;
        for (int length = frame.getPayloadLength(); length > this.maxLength; length -= this.maxLength) {
            frag = new WebSocketFrame(frame);
            frag.setOpCode(opcode);
            frag.setFin(false);
            frag.setContinuation(continuation);
            payload.position(currentPosition);
            payload.limit(Math.min(payload.position() + this.maxLength, originalLimit));
            frag.setPayload(payload);
            this.nextOutgoingFrame(frag);
            opcode = 0;
            continuation = true;
            currentPosition = payload.limit();
        }
        frag = new WebSocketFrame(frame);
        frag.setOpCode(opcode);
        frag.setFin(frame.isFin());
        frag.setContinuation(continuation);
        payload.position(currentPosition);
        payload.limit(originalLimit);
        frag.setPayload(payload);
        return this.nextOutgoingFrame(frag);
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.maxLength = config.getParameter("maxLength", this.maxLength);
    }
}

