/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.client.AuthenticationProtocolHandler;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.ContinueProtocolHandler;
import org.eclipse.jetty.client.GZIPContentDecoder;
import org.eclipse.jetty.client.HttpAuthenticationStore;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.RedirectProtocolHandler;
import org.eclipse.jetty.client.Schedulable;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.ProxyConfiguration;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;

public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<String, HttpDestination> destinations = new ConcurrentHashMap<String, HttpDestination>();
    private final ConcurrentMap<Long, HttpConversation> conversations = new ConcurrentHashMap<Long, HttpConversation>();
    private final List<ProtocolHandler> handlers = new ArrayList<ProtocolHandler>();
    private final List<Request.Listener> requestListeners = new ArrayList<Request.Listener>();
    private final AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private final Set<ContentDecoder.Factory> decoderFactories = new ContentDecoderFactorySet();
    private final SslContextFactory sslContextFactory;
    private volatile CookieManager cookieManager;
    private volatile CookieStore cookieStore;
    private volatile Executor executor;
    private volatile ByteBufferPool byteBufferPool;
    private volatile Scheduler scheduler;
    private volatile SelectorManager selectorManager;
    private volatile HttpField agentField = new HttpField(HttpHeader.USER_AGENT, "Jetty/" + Jetty.VERSION);
    private volatile boolean followRedirects = true;
    private volatile int maxConnectionsPerDestination = 64;
    private volatile int maxRequestsQueuedPerDestination = 1024;
    private volatile int requestBufferSize = 4096;
    private volatile int responseBufferSize = 4096;
    private volatile int maxRedirects = 8;
    private volatile SocketAddress bindAddress;
    private volatile long connectTimeout = 15000L;
    private volatile long idleTimeout;
    private volatile boolean tcpNoDelay = true;
    private volatile boolean dispatchIO = true;
    private volatile ProxyConfiguration proxyConfig;
    private volatile HttpField encodingField;

    public HttpClient() {
        this(null);
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected void doStart() throws Exception {
        if (this.sslContextFactory != null) {
            this.addBean(this.sslContextFactory);
            this.setDispatchIO(false);
        }
        String name = HttpClient.class.getSimpleName() + "@" + ((Object)((Object)this)).hashCode();
        if (this.executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName(name);
            this.executor = threadPool;
        }
        this.addBean(this.executor);
        if (this.byteBufferPool == null) {
            this.byteBufferPool = new MappedByteBufferPool();
        }
        this.addBean(this.byteBufferPool);
        if (this.scheduler == null) {
            this.scheduler = new TimerScheduler(name + "-scheduler");
        }
        this.addBean(this.scheduler);
        this.selectorManager = this.newSelectorManager();
        this.selectorManager.setConnectTimeout(this.getConnectTimeout());
        this.addBean(this.selectorManager);
        this.handlers.add(new ContinueProtocolHandler(this));
        this.handlers.add(new RedirectProtocolHandler(this));
        this.handlers.add(new AuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory());
        this.cookieManager = this.newCookieManager();
        this.cookieStore = this.cookieManager.getCookieStore();
        super.doStart();
        LOG.info("Started {}", new Object[]{this});
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager(this.getExecutor(), this.getScheduler());
    }

    private CookieManager newCookieManager() {
        return new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping {}", new Object[]{this});
        this.cookieStore.removeAll();
        this.cookieStore = null;
        this.decoderFactories.clear();
        this.handlers.clear();
        for (HttpDestination destination : this.destinations.values()) {
            destination.close();
        }
        this.destinations.clear();
        this.conversations.clear();
        this.requestListeners.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
        LOG.info("Stopped {}", new Object[]{this});
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = Objects.requireNonNull(cookieStore);
        this.cookieManager = this.newCookieManager();
    }

    CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    public ContentResponse GET(String uri) throws InterruptedException, ExecutionException, TimeoutException {
        return this.GET(URI.create(uri));
    }

    public ContentResponse GET(URI uri) throws InterruptedException, ExecutionException, TimeoutException {
        return this.newRequest(uri).send();
    }

    public Request POST(String uri) {
        return this.POST(URI.create(uri));
    }

    public Request POST(URI uri) {
        return this.newRequest(uri).method(HttpMethod.POST);
    }

    public Request newRequest(String host, int port) {
        return this.newRequest(URI.create(this.address("http", host, port)));
    }

    public Request newRequest(String uri) {
        return this.newRequest(URI.create(uri));
    }

    public Request newRequest(URI uri) {
        return new HttpRequest(this, uri);
    }

    protected Request copyRequest(Request oldRequest, URI newURI) {
        HttpRequest newRequest = new HttpRequest(this, oldRequest.getConversationID(), newURI);
        newRequest.method(oldRequest.getMethod()).version(oldRequest.getVersion()).content(oldRequest.getContent());
        for (HttpField header : oldRequest.getHeaders()) {
            if (HttpHeader.HOST == header.getHeader()) continue;
            newRequest.header(header.getName(), header.getValue());
        }
        return newRequest;
    }

    private String address(String scheme, String host, int port) {
        return scheme + "://" + host + ":" + port;
    }

    public Destination getDestination(String scheme, String host, int port) {
        return this.provideDestination(scheme, host, port);
    }

    protected HttpDestination provideDestination(String scheme, String host, int port) {
        String address;
        HttpDestination destination;
        if (port <= 0) {
            int n = port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
        if ((destination = (HttpDestination)this.destinations.get(address = this.address(scheme, host, port))) == null) {
            destination = new HttpDestination(this, scheme, host, port);
            if (this.isRunning()) {
                HttpDestination existing = this.destinations.putIfAbsent(address, destination);
                if (existing != null) {
                    destination = existing;
                } else {
                    LOG.debug("Created {}", new Object[]{destination});
                }
                if (!this.isRunning()) {
                    this.destinations.remove(address);
                }
            }
        }
        return destination;
    }

    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinations.values());
    }

    protected void send(Request request, List<Response.ResponseListener> listeners) {
        String scheme = request.getScheme().toLowerCase(Locale.ENGLISH);
        if (!Arrays.asList("http", "https").contains(scheme)) {
            throw new IllegalArgumentException("Invalid protocol " + scheme);
        }
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Schedulable)) continue;
            ((Schedulable)((Object)listener)).schedule(this.scheduler);
        }
        HttpDestination destination = this.provideDestination(scheme, request.getHost(), request.getPort());
        destination.send(request, listeners);
    }

    protected void newConnection(HttpDestination destination, Promise<Connection> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            SocketAddress bindAddress = this.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(channel);
            channel.configureBlocking(false);
            channel.connect(destination.getConnectAddress());
            ConnectionCallback result = new ConnectionCallback(destination, promise);
            this.selectorManager.connect(channel, (Object)result);
        }
        catch (IOException x) {
            if (channel != null) {
                this.close(channel);
            }
            promise.failed((Throwable)x);
        }
    }

    protected void configure(SocketChannel channel) throws SocketException {
        channel.socket().setTcpNoDelay(this.isTCPNoDelay());
    }

    private void close(SocketChannel channel) {
        try {
            channel.close();
        }
        catch (IOException x) {
            LOG.ignore((Throwable)x);
        }
    }

    protected HttpConversation getConversation(long id, boolean create) {
        HttpConversation conversation = (HttpConversation)this.conversations.get(id);
        if (conversation == null && create) {
            conversation = new HttpConversation(this, id);
            HttpConversation existing = this.conversations.putIfAbsent(id, conversation);
            if (existing != null) {
                conversation = existing;
            } else {
                LOG.debug("{} created", new Object[]{conversation});
            }
        }
        return conversation;
    }

    protected void removeConversation(HttpConversation conversation) {
        this.conversations.remove(conversation.id());
        LOG.debug("{} removed", new Object[]{conversation});
    }

    protected List<ProtocolHandler> getProtocolHandlers() {
        return this.handlers;
    }

    protected ProtocolHandler findProtocolHandler(Request request, Response response) {
        List<ProtocolHandler> protocolHandlers = this.getProtocolHandlers();
        for (int i = 0; i < protocolHandlers.size(); ++i) {
            ProtocolHandler handler = protocolHandlers.get(i);
            if (!handler.accept(request, response)) continue;
            return handler;
        }
        return null;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public HttpField getUserAgentField() {
        return this.agentField;
    }

    public void setUserAgentField(HttpField agent) {
        if (agent.getHeader() != HttpHeader.USER_AGENT) {
            throw new IllegalArgumentException();
        }
        this.agentField = agent;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    public void setMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
    }

    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    public void setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isDispatchIO() {
        return this.dispatchIO;
    }

    public void setDispatchIO(boolean dispatchIO) {
        this.dispatchIO = dispatchIO;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfig;
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    protected HttpField getAcceptEncodingField() {
        return this.encodingField;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        HttpClient.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this.getBeans(), this.destinations.values()});
    }

    private class ContentDecoderFactorySet
    implements Set<ContentDecoder.Factory> {
        private final Set<ContentDecoder.Factory> set = new HashSet<ContentDecoder.Factory>();

        private ContentDecoderFactorySet() {
        }

        @Override
        public boolean add(ContentDecoder.Factory e) {
            boolean result = this.set.add(e);
            this.invalidate();
            return result;
        }

        @Override
        public boolean addAll(Collection<? extends ContentDecoder.Factory> c) {
            boolean result = this.set.addAll(c);
            this.invalidate();
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = this.set.remove(o);
            this.invalidate();
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = this.set.removeAll(c);
            this.invalidate();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = this.set.retainAll(c);
            this.invalidate();
            return result;
        }

        @Override
        public void clear() {
            this.set.clear();
            this.invalidate();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public Iterator<ContentDecoder.Factory> iterator() {
            return this.set.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.set.toArray(a);
        }

        protected void invalidate() {
            if (this.set.isEmpty()) {
                HttpClient.this.encodingField = null;
            } else {
                StringBuilder value = new StringBuilder();
                Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
                while (iterator.hasNext()) {
                    ContentDecoder.Factory decoderFactory = iterator.next();
                    value.append(decoderFactory.getEncoding());
                    if (!iterator.hasNext()) continue;
                    value.append(",");
                }
                HttpClient.this.encodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, value.toString());
            }
        }
    }

    private class ConnectionCallback
    extends FuturePromise<Connection> {
        private final HttpDestination destination;
        private final Promise<Connection> promise;

        private ConnectionCallback(HttpDestination destination, Promise<Connection> promise) {
            this.destination = destination;
            this.promise = promise;
        }
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        public ClientSelectorManager(Executor executor, Scheduler scheduler) {
            this(executor, scheduler, 1);
        }

        public ClientSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key) {
            return new SelectChannelEndPoint(channel, selector, key, this.getScheduler(), HttpClient.this.getIdleTimeout());
        }

        public org.eclipse.jetty.io.Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            ConnectionCallback callback = (ConnectionCallback)((Object)attachment);
            HttpDestination destination = callback.destination;
            SslContextFactory sslContextFactory = HttpClient.this.getSslContextFactory();
            if ("https".equals(destination.getScheme())) {
                if (sslContextFactory == null) {
                    ConnectException failure = new ConnectException("Missing " + SslContextFactory.class.getSimpleName() + " for " + destination.getScheme() + " requests");
                    callback.failed(failure);
                    throw failure;
                }
                SSLEngine engine = sslContextFactory.newSSLEngine(endPoint.getRemoteAddress());
                engine.setUseClientMode(true);
                SslConnection sslConnection = new SslConnection(HttpClient.this.getByteBufferPool(), this.getExecutor(), endPoint, engine);
                SslConnection.DecryptedEndPoint appEndPoint = sslConnection.getDecryptedEndPoint();
                HttpConnection connection = new HttpConnection(HttpClient.this, (EndPoint)appEndPoint, destination);
                appEndPoint.setConnection((org.eclipse.jetty.io.Connection)connection);
                callback.promise.succeeded((Object)connection);
                return sslConnection;
            }
            HttpConnection connection = new HttpConnection(HttpClient.this, endPoint, destination);
            callback.promise.succeeded((Object)connection);
            return connection;
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            ConnectionCallback callback = (ConnectionCallback)((Object)attachment);
            callback.promise.failed(ex);
        }
    }
}

