/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpReceiver
implements HttpParser.ResponseHandler<ByteBuffer> {
    private static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private final HttpParser parser = new HttpParser((HttpParser.ResponseHandler)this);
    private final HttpConnection connection;
    private final ResponseNotifier responseNotifier;
    private ContentDecoder decoder;

    public HttpReceiver(HttpConnection connection) {
        this.connection = connection;
        this.responseNotifier = new ResponseNotifier(connection.getHttpClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() {
        EndPoint endPoint = this.connection.getEndPoint();
        HttpClient client = this.connection.getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        ByteBuffer buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
        try {
            int read;
            while (true) {
                read = endPoint.fill(buffer);
                LOG.debug("Read {} bytes from {}", new Object[]{read, this.connection});
                if (read <= 0) break;
                this.parse(buffer);
            }
            if (read == 0) {
                this.fillInterested();
            } else {
                this.shutdown();
            }
        }
        catch (EofException x) {
            LOG.ignore((Throwable)x);
            this.failAndClose(x);
        }
        catch (Exception x) {
            LOG.debug((Throwable)x);
            this.failAndClose(x);
        }
        finally {
            bufferPool.release(buffer);
        }
    }

    private void parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.parser.parseNext(buffer);
        }
    }

    private void fillInterested() {
        State state = this.state.get();
        if (state == State.IDLE || state == State.RECEIVE) {
            this.connection.fillInterested();
        }
    }

    private void shutdown() {
        this.parser.shutdownInput();
        State state = this.state.get();
        if (!(state != State.IDLE && state != State.RECEIVE || this.fail(new EOFException()))) {
            this.connection.close();
        }
    }

    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange;
        if (this.updateState(State.IDLE, State.RECEIVE) && (exchange = this.connection.getExchange()) != null) {
            Response.Listener handlerListener;
            HttpConversation conversation = exchange.getConversation();
            HttpResponse response = exchange.getResponse();
            this.parser.setHeadResponse(exchange.getRequest().getMethod() == HttpMethod.HEAD);
            response.version(version).status(status).reason(reason);
            HttpExchange initialExchange = conversation.getExchanges().peekFirst();
            HttpClient client = this.connection.getHttpClient();
            ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
            Response.Listener listener = handlerListener = protocolHandler == null ? null : protocolHandler.getResponseListener();
            if (handlerListener == null) {
                exchange.setLast(true);
                if (initialExchange == exchange) {
                    conversation.setResponseListeners(exchange.getResponseListeners());
                } else {
                    ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(exchange.getResponseListeners());
                    listeners.addAll(initialExchange.getResponseListeners());
                    conversation.setResponseListeners(listeners);
                }
            } else {
                LOG.debug("Found protocol handler {}", new Object[]{protocolHandler});
                if (initialExchange == exchange) {
                    conversation.setResponseListeners(Collections.singletonList(handlerListener));
                } else {
                    ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(exchange.getResponseListeners());
                    listeners.add(handlerListener);
                    conversation.setResponseListeners(listeners);
                }
            }
            LOG.debug("Receiving {}", new Object[]{response});
            this.responseNotifier.notifyBegin(conversation.getResponseListeners(), (Response)response);
        }
        return false;
    }

    public boolean parsedHeader(HttpField field) {
        HttpExchange exchange;
        if (this.updateState(State.RECEIVE, State.RECEIVE) && (exchange = this.connection.getExchange()) != null) {
            HttpConversation conversation = exchange.getConversation();
            HttpResponse response = exchange.getResponse();
            boolean process = this.responseNotifier.notifyHeader(conversation.getResponseListeners(), (Response)response, field);
            if (process) {
                response.getHeaders().add(field);
                HttpHeader fieldHeader = field.getHeader();
                if (fieldHeader != null) {
                    switch (fieldHeader) {
                        case SET_COOKIE: 
                        case SET_COOKIE2: {
                            this.storeCookie(exchange.getRequest().getURI(), field);
                            break;
                        }
                    }
                }
            }
        }
        return false;
    }

    private void storeCookie(URI uri, HttpField field) {
        try {
            HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
            header.put(field.getHeader().asString(), Collections.singletonList(field.getValue()));
            this.connection.getHttpClient().getCookieManager().put(uri, header);
        }
        catch (IOException x) {
            LOG.debug((Throwable)x);
        }
    }

    public boolean headerComplete() {
        HttpExchange exchange;
        if (this.updateState(State.RECEIVE, State.RECEIVE) && (exchange = this.connection.getExchange()) != null) {
            HttpConversation conversation = exchange.getConversation();
            HttpResponse response = exchange.getResponse();
            LOG.debug("Headers {}", new Object[]{response});
            this.responseNotifier.notifyHeaders(conversation.getResponseListeners(), (Response)response);
            Enumeration contentEncodings = response.getHeaders().getValues(HttpHeader.CONTENT_ENCODING.asString(), ",");
            if (contentEncodings != null) {
                block0: for (ContentDecoder.Factory factory : this.connection.getHttpClient().getContentDecoderFactories()) {
                    while (contentEncodings.hasMoreElements()) {
                        if (!factory.getEncoding().equalsIgnoreCase((String)contentEncodings.nextElement())) continue;
                        this.decoder = factory.newContentDecoder();
                        continue block0;
                    }
                }
            }
        }
        return false;
    }

    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange;
        if (this.updateState(State.RECEIVE, State.RECEIVE) && (exchange = this.connection.getExchange()) != null) {
            HttpConversation conversation = exchange.getConversation();
            HttpResponse response = exchange.getResponse();
            LOG.debug("Content {}: {} bytes", new Object[]{response, buffer.remaining()});
            ContentDecoder decoder = this.decoder;
            if (decoder != null) {
                buffer = decoder.decode(buffer);
                LOG.debug("{} {}: {} bytes", new Object[]{decoder, response, buffer.remaining()});
            }
            this.responseNotifier.notifyContent(conversation.getResponseListeners(), (Response)response, buffer);
        }
        return false;
    }

    public boolean messageComplete() {
        if (this.updateState(State.RECEIVE, State.RECEIVE)) {
            this.success();
        }
        return true;
    }

    protected boolean success() {
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.responseComplete(null);
        if (!completion.isMarked()) {
            return false;
        }
        this.parser.reset();
        this.decoder = null;
        if (!this.updateState(State.RECEIVE, State.IDLE)) {
            throw new IllegalStateException();
        }
        exchange.terminateResponse();
        HttpResponse response = exchange.getResponse();
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        this.responseNotifier.notifySuccess(listeners, (Response)response);
        LOG.debug("Received {}", new Object[]{response});
        Result result = completion.getReference();
        if (result != null) {
            this.connection.complete(exchange, !result.isFailed());
            this.responseNotifier.notifyComplete(listeners, result);
        }
        return true;
    }

    protected boolean fail(Throwable failure) {
        State current;
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.responseComplete(failure);
        if (!completion.isMarked()) {
            return false;
        }
        this.parser.close();
        this.decoder = null;
        while (!this.updateState(current = this.state.get(), State.FAILURE)) {
        }
        exchange.terminateResponse();
        HttpResponse response = exchange.getResponse();
        HttpConversation conversation = exchange.getConversation();
        this.responseNotifier.notifyFailure(conversation.getResponseListeners(), (Response)response, failure);
        LOG.debug("Failed {} {}", new Object[]{response, failure});
        Result result = completion.getReference();
        if (result != null) {
            this.connection.complete(exchange, false);
            this.responseNotifier.notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    public boolean earlyEOF() {
        this.failAndClose(new EOFException());
        return false;
    }

    private void failAndClose(Throwable failure) {
        this.fail(failure);
        this.connection.close();
    }

    public void badMessage(int status, String reason) {
        HttpExchange exchange = this.connection.getExchange();
        HttpResponse response = exchange.getResponse();
        response.status(status).reason(reason);
        this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response", response));
    }

    public void idleTimeout() {
        this.fail(new TimeoutException());
    }

    public boolean abort(HttpExchange exchange, Throwable cause) {
        return this.fail(cause);
    }

    private boolean updateState(State from, State to) {
        boolean updated = this.state.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.state.get()});
        }
        return updated;
    }

    private static enum State {
        IDLE,
        RECEIVE,
        FAILURE;

    }
}

