/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.LoginCallbackImpl;
import org.eclipse.jetty.security.jaspi.callback.CredentialValidationCallback;
import org.eclipse.jetty.server.UserIdentity;

public class ServletCallbackHandler
implements CallbackHandler {
    private final LoginService _loginService;
    private final ThreadLocal<CallerPrincipalCallback> _callerPrincipals = new ThreadLocal();
    private final ThreadLocal<GroupPrincipalCallback> _groupPrincipals = new ThreadLocal();

    public ServletCallbackHandler(LoginService loginService) {
        this._loginService = loginService;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            Subject subject;
            if (callback instanceof CallerPrincipalCallback) {
                this._callerPrincipals.set((CallerPrincipalCallback)callback);
                continue;
            }
            if (callback instanceof GroupPrincipalCallback) {
                this._groupPrincipals.set((GroupPrincipalCallback)callback);
                continue;
            }
            if (callback instanceof PasswordValidationCallback) {
                PasswordValidationCallback passwordValidationCallback = (PasswordValidationCallback)callback;
                subject = passwordValidationCallback.getSubject();
                UserIdentity user = this._loginService.login(passwordValidationCallback.getUsername(), (Object)passwordValidationCallback.getPassword());
                if (user == null) continue;
                passwordValidationCallback.setResult(true);
                passwordValidationCallback.getSubject().getPrincipals().addAll(user.getSubject().getPrincipals());
                passwordValidationCallback.getSubject().getPrivateCredentials().add(user);
                continue;
            }
            if (callback instanceof CredentialValidationCallback) {
                CredentialValidationCallback credentialValidationCallback = (CredentialValidationCallback)callback;
                subject = credentialValidationCallback.getSubject();
                LoginCallbackImpl loginCallback = new LoginCallbackImpl(subject, credentialValidationCallback.getUsername(), (Object)credentialValidationCallback.getCredential());
                UserIdentity user = this._loginService.login(credentialValidationCallback.getUsername(), (Object)credentialValidationCallback.getCredential());
                if (user == null) continue;
                loginCallback.setUserPrincipal(user.getUserPrincipal());
                credentialValidationCallback.getSubject().getPrivateCredentials().add(loginCallback);
                credentialValidationCallback.setResult(true);
                credentialValidationCallback.getSubject().getPrincipals().addAll(user.getSubject().getPrincipals());
                credentialValidationCallback.getSubject().getPrivateCredentials().add(user);
                continue;
            }
            if (callback instanceof CertStoreCallback || callback instanceof PrivateKeyCallback || callback instanceof SecretKeyCallback || callback instanceof TrustStoreCallback) continue;
            throw new UnsupportedCallbackException(callback);
        }
    }

    public CallerPrincipalCallback getThreadCallerPrincipalCallback() {
        CallerPrincipalCallback callerPrincipalCallback = this._callerPrincipals.get();
        this._callerPrincipals.remove();
        return callerPrincipalCallback;
    }

    public GroupPrincipalCallback getThreadGroupPrincipalCallback() {
        GroupPrincipalCallback groupPrincipalCallback = this._groupPrincipals.get();
        this._groupPrincipals.remove();
        return groupPrincipalCallback;
    }
}

