/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.StandardStream;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.GoAwayReceivedInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;

public class ProxyHTTPSPDYConnection
extends HttpConnection
implements HttpParser.RequestHandler<ByteBuffer> {
    private final short version;
    private final Fields headers = new Fields();
    private final ProxyEngineSelector proxyEngineSelector;
    private final ISession session;
    private HTTPStream stream;
    private ByteBuffer content;

    public ProxyHTTPSPDYConnection(Connector connector, HttpConfiguration config, EndPoint endPoint, short version, ProxyEngineSelector proxyEngineSelector) {
        super(config, connector, endPoint);
        this.version = version;
        this.proxyEngineSelector = proxyEngineSelector;
        this.session = new HTTPSession(version, connector);
    }

    protected HttpParser.RequestHandler<ByteBuffer> newRequestHandler() {
        return this;
    }

    public boolean startRequest(HttpMethod method, String methodString, ByteBuffer uri, HttpVersion httpVersion) {
        Connector connector = this.getConnector();
        String scheme = connector.getConnectionFactory(SslConnectionFactory.class) != null ? "https" : "http";
        this.headers.put(HTTPSPDYHeader.SCHEME.name(this.version), scheme);
        this.headers.put(HTTPSPDYHeader.METHOD.name(this.version), methodString);
        this.headers.put(HTTPSPDYHeader.URI.name(this.version), BufferUtil.toUTF8String((ByteBuffer)uri));
        this.headers.put(HTTPSPDYHeader.VERSION.name(this.version), httpVersion.asString());
        return false;
    }

    public boolean parsedHeader(HttpField field) {
        if (field.getHeader() == HttpHeader.HOST) {
            this.headers.put(HTTPSPDYHeader.HOST.name(this.version), field.getValue());
        } else {
            this.headers.put(field.getName(), field.getValue());
        }
        return false;
    }

    public boolean parsedHostHeader(String host, int port) {
        return false;
    }

    public boolean headerComplete() {
        return false;
    }

    public boolean content(ByteBuffer item) {
        if (this.content == null) {
            this.stream = this.syn(false);
            this.content = item;
        } else {
            this.stream.getStreamFrameListener().onData((Stream)this.stream, this.toDataInfo(item, false));
        }
        return false;
    }

    public boolean messageComplete() {
        if (this.stream == null) {
            assert (this.content == null);
            if (this.headers.isEmpty()) {
                this.proxyEngineSelector.onGoAway((Session)this.session, new GoAwayReceivedInfo(0, SessionStatus.OK));
            } else {
                this.syn(true);
            }
        } else {
            this.stream.getStreamFrameListener().onData((Stream)this.stream, this.toDataInfo(this.content, true));
        }
        this.headers.clear();
        this.stream = null;
        this.content = null;
        return false;
    }

    public boolean earlyEOF() {
        return false;
    }

    public void badMessage(int status, String reason) {
    }

    private HTTPStream syn(boolean close) {
        HTTPStream stream = new HTTPStream(1, 0, this.session, null);
        StreamFrameListener streamFrameListener = this.proxyEngineSelector.onSyn((Stream)stream, new SynInfo(this.headers, close));
        stream.setStreamFrameListener(streamFrameListener);
        return stream;
    }

    private DataInfo toDataInfo(ByteBuffer buffer, boolean close) {
        return new ByteBufferDataInfo(buffer, close);
    }

    private class HTTPPushStream
    extends StandardStream {
        private HTTPPushStream(int id, byte priority, ISession session, IStream associatedStream) {
            super(id, priority, session, associatedStream, null);
        }

        public void headers(HeadersInfo headersInfo, Callback handler) {
            handler.succeeded();
        }

        public void data(DataInfo dataInfo, Callback handler) {
            handler.succeeded();
        }
    }

    private class HTTPStream
    extends StandardStream {
        private final Pattern statusRegexp;

        private HTTPStream(int id, byte priority, ISession session, IStream associatedStream) {
            super(id, priority, session, associatedStream, null);
            this.statusRegexp = Pattern.compile("(\\d{3})\\s+(.*)");
        }

        public void push(PushInfo pushInfo, Promise<Stream> handler) {
            handler.succeeded((Object)new HTTPPushStream(2, this.getPriority(), this.getSession(), (IStream)this));
        }

        public void headers(HeadersInfo headersInfo, Callback handler) {
            throw new UnsupportedOperationException("Not Yet Implemented");
        }

        public void reply(ReplyInfo replyInfo, Callback handler) {
            try {
                Fields headers = new Fields(replyInfo.getHeaders(), false);
                headers.remove(HTTPSPDYHeader.SCHEME.name(ProxyHTTPSPDYConnection.this.version));
                String status = headers.remove(HTTPSPDYHeader.STATUS.name(ProxyHTTPSPDYConnection.this.version)).value();
                Matcher matcher = this.statusRegexp.matcher(status);
                matcher.matches();
                int code = Integer.parseInt(matcher.group(1));
                String reason = matcher.group(2).trim();
                HttpVersion httpVersion = HttpVersion.fromString((String)headers.remove(HTTPSPDYHeader.VERSION.name(ProxyHTTPSPDYConnection.this.version)).value());
                Fields.Field host = headers.remove(HTTPSPDYHeader.HOST.name(ProxyHTTPSPDYConnection.this.version));
                if (host != null) {
                    headers.put("host", host.value());
                }
                HttpFields fields = new HttpFields();
                for (Fields.Field header : headers) {
                    String name = this.camelize(header.name());
                    fields.put(name, header.value());
                }
                HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(httpVersion, fields, -1L, code, reason, false);
                ProxyHTTPSPDYConnection.this.send(info, null, replyInfo.isClose());
                if (replyInfo.isClose()) {
                    ProxyHTTPSPDYConnection.this.completed();
                }
                handler.succeeded();
            }
            catch (IOException x) {
                handler.failed((Throwable)x);
            }
        }

        private String camelize(String name) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                int j = i + 1;
                if (c != '-' || j >= chars.length) continue;
                chars[j] = Character.toUpperCase(chars[j]);
            }
            return new String(chars);
        }

        public void data(DataInfo dataInfo, Callback handler) {
            try {
                ByteBuffer byteBuffer = dataInfo.asByteBuffer(false);
                ProxyHTTPSPDYConnection.this.send(null, byteBuffer, dataInfo.isClose());
                if (dataInfo.isClose()) {
                    ProxyHTTPSPDYConnection.this.completed();
                }
                handler.succeeded();
            }
            catch (IOException x) {
                handler.failed((Throwable)x);
            }
        }
    }

    private class HTTPSession
    extends StandardSession {
        private HTTPSession(short version, Connector connector) {
            super(version, connector.getByteBufferPool(), connector.getExecutor(), connector.getScheduler(), null, ProxyHTTPSPDYConnection.this.getEndPoint(), null, 1, (SessionFrameListener)ProxyHTTPSPDYConnection.this.proxyEngineSelector, null, null);
        }

        public void rst(RstInfo rstInfo, Callback handler) {
            this.goAway(new GoAwayInfo(rstInfo.getTimeout(), rstInfo.getUnit()), handler);
        }

        public void goAway(GoAwayInfo goAwayInfo, Callback handler) {
            ProxyHTTPSPDYConnection.this.getEndPoint().close();
            handler.succeeded();
        }
    }
}

