/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.AbstractOSGiApp;
import org.eclipse.jetty.osgi.boot.OSGiWebappConstants;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.internal.webapp.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.utils.OSGiClassLoader;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;

public abstract class AbstractContextProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger LOG = Log.getLogger(AbstractContextProvider.class);
    private DeploymentManager _deploymentManager;
    private ServerInstanceWrapper _serverWrapper;

    public AbstractContextProvider(ServerInstanceWrapper wrapper) {
        this._serverWrapper = wrapper;
    }

    public ServerInstanceWrapper getServerInstanceWrapper() {
        return this._serverWrapper;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        if (app == null) {
            return null;
        }
        if (!(app instanceof OSGiApp)) {
            throw new IllegalStateException(app + " is not a BundleApp");
        }
        ContextHandler h = ((OSGiApp)app).createContextHandler();
        return h;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public class OSGiApp
    extends AbstractOSGiApp {
        private String _contextFile;
        private ContextHandler _contextHandler;
        private boolean _configured;

        public OSGiApp(DeploymentManager manager, AppProvider provider, String originId, Bundle bundle, String contextFile) {
            super(manager, provider, bundle, originId);
            this._configured = false;
            this._contextFile = contextFile;
        }

        public OSGiApp(DeploymentManager manager, AppProvider provider, Bundle bundle, Dictionary properties, String contextFile, String originId) {
            super(manager, provider, bundle, properties, originId);
            this._configured = false;
            this._contextFile = contextFile;
        }

        public String getContextFile() {
            return this._contextFile;
        }

        public void setHandler(ContextHandler h) {
            this._contextHandler = h;
        }

        public ContextHandler createContextHandler() throws Exception {
            this.configureContextHandler();
            return this._contextHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureContextHandler() throws Exception {
            Resource jarResource;
            if (this._configured) {
                return;
            }
            this._configured = true;
            String bundleOverrideLocation = (String)this._properties.get("Jetty-bundleInstall");
            if (bundleOverrideLocation == null) {
                bundleOverrideLocation = (String)this._properties.get("thisBundleInstall");
            }
            File bundleLocation = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(this._bundle);
            File root = bundleOverrideLocation == null ? bundleLocation : new File(bundleOverrideLocation);
            Resource rootResource = Resource.newResource((URL)BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(root.toURI().toURL()));
            if (rootResource.exists() && !rootResource.isDirectory() && !rootResource.toString().startsWith("jar:") && (jarResource = JarResource.newJarResource((Resource)rootResource)).exists() && jarResource.isDirectory()) {
                rootResource = jarResource;
            }
            if (this._contextHandler != null && this._contextHandler.getBaseResource() == null) {
                this._contextHandler.setBaseResource(rootResource);
            }
            OSGiClassLoader classLoader = new OSGiClassLoader(AbstractContextProvider.this.getServerInstanceWrapper().getParentClassLoaderForWebapps(), this._bundle);
            if (this._contextFile == null && this._contextHandler == null) {
                throw new IllegalStateException("No context file or ContextHandler");
            }
            if (this._contextFile != null) {
                Resource res = null;
                if (this._contextFile.startsWith("/")) {
                    res = this.getFileAsResource(this._contextFile);
                }
                if (res == null) {
                    String jettyHome = (String)AbstractContextProvider.this.getServerInstanceWrapper().getServer().getAttribute("jetty.home");
                    if (jettyHome != null) {
                        res = this.getFileAsResource(jettyHome, this._contextFile);
                    }
                    if (res == null && (jettyHome = System.getProperty("jetty.home")) != null) {
                        if (jettyHome.startsWith("\"") || jettyHome.startsWith("'")) {
                            jettyHome = jettyHome.substring(1);
                        }
                        if (jettyHome.endsWith("\"") || jettyHome.endsWith("'")) {
                            jettyHome = jettyHome.substring(0, jettyHome.length() - 1);
                        }
                        res = this.getFileAsResource(jettyHome, this._contextFile);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("jetty home context file:" + res, new Object[0]);
                        }
                    }
                }
                if (res == null && bundleOverrideLocation != null) {
                    res = this.getFileAsResource(Resource.newResource((String)bundleOverrideLocation).getFile(), this._contextFile);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Bundle override location context file:" + res, new Object[0]);
                    }
                }
                if (res == null) {
                    URL contextURL;
                    if (this._contextFile.startsWith("./")) {
                        this._contextFile = this._contextFile.substring(1);
                    }
                    if (!this._contextFile.startsWith("/")) {
                        this._contextFile = "/" + this._contextFile;
                    }
                    if ((contextURL = this._bundle.getEntry(this._contextFile)) != null) {
                        res = Resource.newResource((URL)contextURL);
                    }
                }
                if (res != null) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    LOG.debug("Context classloader = " + cl, new Object[0]);
                    try {
                        Thread.currentThread().setContextClassLoader(classLoader);
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(res.getInputStream());
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        properties.put("Server", AbstractContextProvider.this.getServerInstanceWrapper().getServer());
                        properties.put("bundle.root", rootResource.toString());
                        xmlConfiguration.getProperties().putAll(properties);
                        if (this._contextHandler == null) {
                            this._contextHandler = (ContextHandler)xmlConfiguration.configure();
                        } else {
                            xmlConfiguration.configure((Object)this._contextHandler);
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
            }
            this._contextHandler.setClassLoader((ClassLoader)classLoader);
            String contextPath = (String)this._properties.get("Web-ContextPath");
            if (contextPath == null) {
                contextPath = (String)this._properties.get("contextPath");
            }
            if (contextPath != null) {
                this._contextHandler.setContextPath(contextPath);
            }
            this._contextHandler.setAttribute("osgi-bundlecontext", (Object)this._bundle.getBundleContext());
            String[] targets = this._contextHandler.getProtectedTargets();
            int length = targets == null ? 0 : targets.length;
            String[] updatedTargets = null;
            if (targets != null) {
                updatedTargets = new String[length + OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
                System.arraycopy(targets, 0, updatedTargets, 0, length);
            } else {
                updatedTargets = new String[OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
            }
            System.arraycopy(OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS, 0, updatedTargets, length, OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length);
            this._contextHandler.setProtectedTargets(updatedTargets);
        }

        private Resource getFileAsResource(String dir, String file) {
            Resource r = null;
            try {
                File asFile = new File(dir, file);
                if (asFile.exists()) {
                    r = Resource.newResource((File)asFile);
                }
            }
            catch (Exception e) {
                r = null;
            }
            return r;
        }

        private Resource getFileAsResource(String file) {
            Resource r = null;
            try {
                File asFile = new File(file);
                if (asFile.exists()) {
                    r = Resource.newResource((File)asFile);
                }
            }
            catch (Exception e) {
                r = null;
            }
            return r;
        }

        private Resource getFileAsResource(File dir, String file) {
            Resource r = null;
            try {
                File asFile = new File(dir, file);
                if (asFile.exists()) {
                    r = Resource.newResource((File)asFile);
                }
            }
            catch (Exception e) {
                r = null;
            }
            return r;
        }
    }
}

