/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Callback;

public interface Response {
    public Request getRequest();

    public <T extends ResponseListener> List<T> getListeners(Class<T> var1);

    public HttpVersion getVersion();

    public int getStatus();

    public String getReason();

    public HttpFields getHeaders();

    public boolean abort(Throwable var1);

    public static interface AsyncContentListener
    extends ResponseListener {
        public void onContent(Response var1, ByteBuffer var2, Callback var3);
    }

    public static interface BeginListener
    extends ResponseListener {
        public void onBegin(Response var1);
    }

    public static interface CompleteListener
    extends ResponseListener {
        public void onComplete(Result var1);
    }

    public static interface ContentListener
    extends ResponseListener {
        public void onContent(Response var1, ByteBuffer var2);
    }

    public static interface FailureListener
    extends ResponseListener {
        public void onFailure(Response var1, Throwable var2);
    }

    public static interface HeaderListener
    extends ResponseListener {
        public boolean onHeader(Response var1, HttpField var2);
    }

    public static interface HeadersListener
    extends ResponseListener {
        public void onHeaders(Response var1);
    }

    public static interface Listener
    extends BeginListener,
    HeaderListener,
    HeadersListener,
    ContentListener,
    AsyncContentListener,
    SuccessListener,
    FailureListener,
    CompleteListener {

        public static class Adapter
        implements Listener {
            @Override
            public void onBegin(Response response) {
            }

            @Override
            public boolean onHeader(Response response, HttpField field) {
                return true;
            }

            @Override
            public void onHeaders(Response response) {
            }

            @Override
            public void onContent(Response response, ByteBuffer content) {
            }

            @Override
            public void onContent(Response response, ByteBuffer content, Callback callback) {
                try {
                    this.onContent(response, content);
                    callback.succeeded();
                }
                catch (Exception x) {
                    callback.failed((Throwable)x);
                }
            }

            @Override
            public void onSuccess(Response response) {
            }

            @Override
            public void onFailure(Response response, Throwable failure) {
            }

            @Override
            public void onComplete(Result result) {
            }
        }
    }

    public static interface ResponseListener
    extends EventListener {
    }

    public static interface SuccessListener
    extends ResponseListener {
        public void onSuccess(Response var1);
    }
}

