/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.bindings.StandardStarter;
import org.eclipse.jetty.deploy.bindings.StandardStopper;
import org.eclipse.jetty.osgi.boot.AbstractContextProvider;
import org.eclipse.jetty.osgi.boot.AbstractWebAppProvider;
import org.eclipse.jetty.osgi.boot.BundleContextProvider;
import org.eclipse.jetty.osgi.boot.BundleWebAppProvider;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.OSGiDeployer;
import org.eclipse.jetty.osgi.boot.OSGiUndeployer;
import org.eclipse.jetty.osgi.boot.ServiceContextProvider;
import org.eclipse.jetty.osgi.boot.ServiceWebAppProvider;
import org.eclipse.jetty.osgi.boot.internal.webapp.LibExtClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.utils.FakeURLClassLoader;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.eclipse.jetty.osgi.boot.utils.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ServerInstanceWrapper {
    public static final String PROPERTY_THIS_JETTY_XML_FOLDER_URL = "this.jetty.xml.parent.folder.url";
    private static Collection<TldBundleDiscoverer> __containerTldBundleDiscoverers = new ArrayList<TldBundleDiscoverer>();
    private static Logger LOG = Log.getLogger((String)ServerInstanceWrapper.class.getName());
    private final String _managedServerName;
    private Server _server;
    private ContextHandlerCollection _ctxtCollection;
    private ClassLoader _commonParentClassLoaderForWebapps;
    private DeploymentManager _deploymentManager;

    public static void addContainerTldBundleDiscoverer(TldBundleDiscoverer tldBundleDiscoverer) {
        __containerTldBundleDiscoverers.add(tldBundleDiscoverer);
    }

    public static Collection<TldBundleDiscoverer> getContainerTldBundleDiscoverers() {
        return __containerTldBundleDiscoverers;
    }

    public static Server configure(Server server, List<URL> jettyConfigurations, Dictionary<String, Object> props) throws Exception {
        if (jettyConfigurations == null || jettyConfigurations.isEmpty()) {
            return server;
        }
        Map<String, Object> idMap = new HashMap<String, Server>();
        if (server != null) {
            idMap.put("Server", server);
            idMap.put((String)props.get("managedServerName"), server);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (props != null) {
            Enumeration<String> en = props.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                Object value = props.get(key);
                properties.put(key, value.toString());
                if (server == null) continue;
                server.setAttribute(key, value);
            }
        }
        for (URL jettyConfiguration : jettyConfigurations) {
            try {
                XmlConfiguration config = new XmlConfiguration(jettyConfiguration);
                config.getIdMap().putAll(idMap);
                config.getProperties().putAll(properties);
                String urlPath = jettyConfiguration.toString();
                int lastSlash = urlPath.lastIndexOf(47);
                if (lastSlash > 4) {
                    urlPath = urlPath.substring(0, lastSlash);
                    config.getProperties().put(PROPERTY_THIS_JETTY_XML_FOLDER_URL, urlPath);
                }
                Object o = config.configure();
                if (server == null) {
                    server = (Server)o;
                }
                idMap = config.getIdMap();
            }
            catch (Exception e) {
                LOG.warn("Configuration error in " + jettyConfiguration, new Object[0]);
                throw e;
            }
        }
        return server;
    }

    public ServerInstanceWrapper(String managedServerName) {
        this._managedServerName = managedServerName;
    }

    public String getManagedServerName() {
        return this._managedServerName;
    }

    public ClassLoader getParentClassLoaderForWebapps() {
        return this._commonParentClassLoaderForWebapps;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Server getServer() {
        return this._server;
    }

    public ContextHandlerCollection getContextHandlerCollection() {
        return this._ctxtCollection;
    }

    public void start(Server server, Dictionary<String, Object> props) throws Exception {
        this._server = server;
        ClassLoader contextCl = Thread.currentThread().getContextClassLoader();
        try {
            List<URL> sharedURLs = this.getManagedJettySharedLibFolderUrls(props);
            ClassLoader libExtClassLoader = LibExtClassLoaderHelper.createLibExtClassLoader(null, sharedURLs, JettyBootstrapActivator.class.getClassLoader());
            if (LOG.isDebugEnabled()) {
                LOG.debug("LibExtClassLoader = " + libExtClassLoader, new Object[0]);
            }
            Thread.currentThread().setContextClassLoader(libExtClassLoader);
            String jettyConfigurationUrls = (String)props.get("jetty.etc.config.urls");
            List<URL> jettyConfigurations = jettyConfigurationUrls != null ? Util.fileNamesAsURLs(jettyConfigurationUrls, ",;") : null;
            this._server = ServerInstanceWrapper.configure(server, jettyConfigurations, props);
            this.init();
            if (!__containerTldBundleDiscoverers.isEmpty()) {
                HashSet<URL> urls = new HashSet<URL>();
                for (TldBundleDiscoverer d : __containerTldBundleDiscoverers) {
                    URL[] list = d.getUrlsForBundlesWithTlds(this._deploymentManager, BundleFileLocatorHelperFactory.getFactory().getHelper());
                    if (list == null) continue;
                    for (URL u : list) {
                        urls.add(u);
                    }
                }
                this._commonParentClassLoaderForWebapps = new FakeURLClassLoader(libExtClassLoader, urls.toArray(new URL[urls.size()]));
            } else {
                this._commonParentClassLoaderForWebapps = libExtClassLoader;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("common classloader = " + this._commonParentClassLoaderForWebapps, new Object[0]);
            }
            server.start();
        }
        catch (Exception e) {
            if (server != null) {
                try {
                    server.stop();
                }
                catch (Exception x) {
                    LOG.ignore((Throwable)x);
                }
            }
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
    }

    public void stop() {
        try {
            if (this._server.isRunning()) {
                this._server.stop();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private void init() {
        AbstractContextProvider contextProvider;
        AbstractWebAppProvider webAppProvider;
        this._ctxtCollection = (ContextHandlerCollection)this._server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this._ctxtCollection == null) {
            throw new IllegalStateException("ERROR: No ContextHandlerCollection configured in Server");
        }
        ArrayList<String> providerClassNames = new ArrayList<String>();
        Collection deployers = this._server.getBeans(DeploymentManager.class);
        if (deployers != null && !deployers.isEmpty()) {
            this._deploymentManager = (DeploymentManager)deployers.iterator().next();
            for (AppProvider provider : this._deploymentManager.getAppProviders()) {
                providerClassNames.add(provider.getClass().getName());
            }
        } else {
            this._deploymentManager = new DeploymentManager();
            this._deploymentManager.setContexts(this._ctxtCollection);
            this._server.addBean((Object)this._deploymentManager);
        }
        this._deploymentManager.setUseStandardBindings(false);
        ArrayList<Object> deploymentLifeCycleBindings = new ArrayList<Object>();
        deploymentLifeCycleBindings.add((Object)new OSGiDeployer(this));
        deploymentLifeCycleBindings.add(new StandardStarter());
        deploymentLifeCycleBindings.add(new StandardStopper());
        deploymentLifeCycleBindings.add((Object)new OSGiUndeployer(this));
        this._deploymentManager.setLifeCycleBindings(deploymentLifeCycleBindings);
        if (!providerClassNames.contains(BundleWebAppProvider.class.getName())) {
            try {
                webAppProvider = new BundleWebAppProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)webAppProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!providerClassNames.contains(ServiceWebAppProvider.class.getName())) {
            try {
                webAppProvider = new ServiceWebAppProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)webAppProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!providerClassNames.contains(BundleContextProvider.class.getName())) {
            try {
                contextProvider = new BundleContextProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)contextProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!providerClassNames.contains(ServiceContextProvider.class.getName())) {
            try {
                contextProvider = new ServiceContextProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)contextProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private List<URL> getManagedJettySharedLibFolderUrls(Dictionary<String, Object> props) {
        String sharedURLs = (String)props.get("managedJettySharedLibFolderUrls");
        if (StringUtil.isBlank((String)sharedURLs)) {
            return null;
        }
        ArrayList<URL> libURLs = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(sharedURLs, ",;", false);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            try {
                URL url = new URL(tok);
                url = BundleFileLocatorHelperFactory.getFactory().getHelper().getFileURL(url);
                if (url.getProtocol().equals("file")) {
                    libURLs.add(new URL("jar:" + url.toExternalForm() + "!/"));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unrecognized Jetty Shared Lib URL: " + url, new Object[0]);
            }
            catch (Throwable mfe) {
                LOG.warn(mfe);
            }
        }
        return libURLs;
    }
}

