/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.IManagedJettyServerRegistry;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.internal.webapp.IWebBundleDeployerHelper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class JettyContextHandlerServiceTracker
implements ServiceListener {
    private final IManagedJettyServerRegistry _registry;
    private Map<ServiceReference, ContextHandler> _indexByServiceReference = new HashMap<ServiceReference, ContextHandler>();
    private Map<String, ServiceReference> _indexByContextFile = new HashMap<String, ServiceReference>();
    private Scanner _scanner;

    public JettyContextHandlerServiceTracker(IManagedJettyServerRegistry registry) throws Exception {
        this._registry = registry;
    }

    public void stop() {
        if (this._scanner != null) {
            this._scanner.stop();
        }
    }

    protected void setupContextHomeScanner(File contextHome) throws IOException {
        if (contextHome == null) {
            return;
        }
        final String osgiContextHomeFolderCanonicalPath = contextHome.getCanonicalPath();
        this._scanner = new Scanner();
        this._scanner.setRecursive(true);
        this._scanner.setReportExistingFilesOnStartup(false);
        this._scanner.addListener((Scanner.Listener)new Scanner.DiscreteListener(){

            public void fileAdded(String filename) throws Exception {
                JettyContextHandlerServiceTracker.this.reloadJettyContextHandler(filename, osgiContextHomeFolderCanonicalPath);
            }

            public void fileChanged(String filename) throws Exception {
                JettyContextHandlerServiceTracker.this.reloadJettyContextHandler(filename, osgiContextHomeFolderCanonicalPath);
            }

            public void fileRemoved(String filename) throws Exception {
                JettyContextHandlerServiceTracker.this.reloadJettyContextHandler(filename, osgiContextHomeFolderCanonicalPath);
            }
        });
    }

    public void serviceChanged(ServiceEvent ev) {
        ServiceReference sr = ev.getServiceReference();
        switch (ev.getType()) {
            case 2: 
            case 4: {
                ContextHandler ctxtHandler = this.unregisterInIndex(ev.getServiceReference());
                if (ctxtHandler != null && !ctxtHandler.isStopped()) {
                    try {
                        this.getWebBundleDeployerHelp(sr).unregister(ctxtHandler);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ev.getType() == 4) break;
            }
            case 1: {
                Bundle contributor = sr.getBundle();
                BundleContext context = FrameworkUtil.getBundle(JettyBootstrapActivator.class).getBundleContext();
                ContextHandler contextHandler = (ContextHandler)context.getService(sr);
                if (contextHandler.getServer() != null) {
                    return;
                }
                String contextFilePath = (String)sr.getProperty("contextFilePath");
                if (contextHandler instanceof WebAppContext && contextFilePath == null) {
                    String defaultWebXmlPath;
                    String webXmlPath;
                    WebAppContext webapp = (WebAppContext)contextHandler;
                    String contextPath = (String)sr.getProperty("contextPath");
                    if (contextPath == null) {
                        contextPath = webapp.getContextPath();
                    }
                    if ((webXmlPath = (String)sr.getProperty("webXmlFilePath")) == null) {
                        webXmlPath = webapp.getDescriptor();
                    }
                    if ((defaultWebXmlPath = (String)sr.getProperty("defaultWebXmlFilePath")) == null) {
                        defaultWebXmlPath = webapp.getDefaultsDescriptor();
                    }
                    String war = (String)sr.getProperty("war");
                    try {
                        WebAppContext handler;
                        IWebBundleDeployerHelper deployerHelper = this.getWebBundleDeployerHelp(sr);
                        if (deployerHelper == null || (handler = deployerHelper.registerWebapplication(contributor, war, contextPath, (String)sr.getProperty("extraClasspath"), (String)sr.getProperty("thisBundleInstall"), webXmlPath, defaultWebXmlPath, webapp)) == null) break;
                        this.registerInIndex((ContextHandler)handler, sr);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if (contextFilePath == null) {
                    throw new IllegalArgumentException("the property contextFilePath is required");
                }
                try {
                    ContextHandler handler;
                    IWebBundleDeployerHelper deployerHelper = this.getWebBundleDeployerHelp(sr);
                    if (deployerHelper == null) break;
                    if (Boolean.TRUE.toString().equals(sr.getProperty("unknownContextHandlerType"))) {
                        contextHandler = null;
                    }
                    if ((handler = deployerHelper.registerContext(contributor, contextFilePath, (String)sr.getProperty("extraClasspath"), (String)sr.getProperty("thisBundleInstall"), contextHandler)) == null) break;
                    this.registerInIndex(handler, sr);
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void registerInIndex(ContextHandler handler, ServiceReference sr) {
        this._indexByServiceReference.put(sr, handler);
        String key = this.getSymbolicNameAndContextFileKey(sr);
        if (key != null) {
            this._indexByContextFile.put(key, sr);
        }
    }

    private ContextHandler unregisterInIndex(ServiceReference sr) {
        ContextHandler handler = this._indexByServiceReference.remove(sr);
        String key = this.getSymbolicNameAndContextFileKey(sr);
        if (key != null) {
            this._indexByContextFile.remove(key);
        }
        if (handler == null) {
            return null;
        }
        return handler;
    }

    private String getSymbolicNameAndContextFileKey(ServiceReference sr) {
        String contextFilePath = (String)sr.getProperty("contextFilePath");
        if (contextFilePath != null) {
            return sr.getBundle().getSymbolicName() + "/" + contextFilePath;
        }
        return null;
    }

    public void reloadJettyContextHandler(String canonicalNameOfFileChanged, String osgiContextHomeFolderCanonicalPath) {
        String key = this.getNormalizedRelativePath(canonicalNameOfFileChanged, osgiContextHomeFolderCanonicalPath);
        if (key == null) {
            return;
        }
        ServiceReference sr = this._indexByContextFile.get(key);
        if (sr == null) {
            return;
        }
        this.serviceChanged(new ServiceEvent(2, sr));
    }

    private String getNormalizedRelativePath(String canFilename, String osgiContextHomeFolderCanonicalPath) {
        if (!canFilename.startsWith(osgiContextHomeFolderCanonicalPath)) {
            return null;
        }
        return canFilename.substring(osgiContextHomeFolderCanonicalPath.length()).replace('\\', '/');
    }

    private ServerInstanceWrapper getServerInstanceWrapper(String managedServerName) {
        if (this._registry == null) {
            return null;
        }
        if (managedServerName == null) {
            managedServerName = "defaultJettyServer";
        }
        ServerInstanceWrapper wrapper = this._registry.getServerInstanceWrapper(managedServerName);
        System.err.println("Returning " + managedServerName + "  = " + wrapper);
        return wrapper;
    }

    private IWebBundleDeployerHelper getWebBundleDeployerHelp(ServiceReference sr) {
        if (this._registry == null) {
            return null;
        }
        String managedServerName = (String)sr.getProperty("managedServerName");
        ServerInstanceWrapper wrapper = this.getServerInstanceWrapper(managedServerName);
        return wrapper != null ? wrapper.getWebBundleDeployerHelp() : null;
    }
}

