/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocketBuffers;

public class WebSocketParser {
    public static final int STATE_START = 0;
    public static final int STATE_SENTINEL_DATA = 1;
    public static final int STATE_LENGTH = 2;
    public static final int STATE_DATA = 3;
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private final EventHandler _handler;
    private int _state;
    private Buffer _buffer;
    private byte _frame;
    private int _length;
    private Utf8StringBuilder _utf8;

    public WebSocketParser(WebSocketBuffers buffers, EndPoint endp, EventHandler handler) {
        this._buffers = buffers;
        this._endp = endp;
        this._handler = handler;
    }

    public boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }

    public Buffer getBuffer() {
        return this._buffer;
    }

    public int parseNext() {
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
        }
        int total_filled = 0;
        boolean progress = true;
        block8: while (true) {
            int length;
            if ((length = this._buffer.length()) == 0 || this._state == 3 && length < this._length) {
                this._buffer.compact();
                if (this._buffer.space() == 0) {
                    throw new IllegalStateException("FULL");
                }
                try {
                    int filled;
                    int n = filled = this._endp.isOpen() ? this._endp.fill(this._buffer) : -1;
                    if (filled <= 0) {
                        return total_filled;
                    }
                    total_filled += filled;
                    length = this._buffer.length();
                }
                catch (IOException e) {
                    Log.debug((Throwable)e);
                    return total_filled > 0 ? total_filled : -1;
                }
            }
            block9: while (true) {
                if (length-- <= 0) continue block8;
                switch (this._state) {
                    case 0: {
                        byte b;
                        this._frame = b = this._buffer.get();
                        if (this._frame < 0) {
                            this._length = 0;
                            this._state = 2;
                            continue block9;
                        }
                        if (this._utf8 == null) {
                            this._utf8 = new Utf8StringBuilder();
                        }
                        this._state = 1;
                        this._buffer.mark();
                        continue block9;
                    }
                    case 1: {
                        byte b = this._buffer.get();
                        if ((b & 0xFF) == 255) {
                            String data = this._utf8.toString();
                            this._utf8.reset();
                            this._state = 0;
                            this._handler.onFrame(this._frame, data);
                            this._buffer.setMarkIndex(-1);
                            if (this._buffer.length() == 0) {
                                this._buffers.returnBuffer(this._buffer);
                                this._buffer = null;
                            }
                            return total_filled;
                        }
                        this._utf8.append(b);
                        continue block9;
                    }
                    case 2: {
                        byte b = this._buffer.get();
                        this._length = this._length << 7 | 0x7F & b;
                        if (b < 0) continue block9;
                        this._state = 3;
                        this._buffer.mark(0);
                        continue block9;
                    }
                    case 3: {
                        if (this._buffer.markIndex() < 0 && this._buffer.length() < this._length) continue block8;
                        Buffer data = this._buffer.sliceFromMark(this._length);
                        this._buffer.skip(this._length);
                        this._state = 0;
                        this._handler.onFrame(this._frame, data);
                        if (this._buffer.length() == 0) {
                            this._buffers.returnBuffer(this._buffer);
                            this._buffer = null;
                        }
                        return total_filled;
                    }
                    default: {
                        continue block9;
                    }
                }
                break;
            }
        }
    }

    public void fill(Buffer buffer) {
        if (buffer != null && buffer.length() > 0) {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer();
            }
            this._buffer.put(buffer);
            buffer.clear();
        }
    }

    static long hixieCrypt(String key) {
        long number = 0L;
        int spaces = 0;
        for (char c : key.toCharArray()) {
            if (Character.isDigit(c)) {
                number = number * 10L + (long)(c - 48);
                continue;
            }
            if (c != ' ') continue;
            ++spaces;
        }
        return number / (long)spaces;
    }

    public static interface EventHandler {
        public void onFrame(byte var1, String var2);

        public void onFrame(byte var1, Buffer var2);
    }
}

