/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import org.apache.jasper.security.SecurityUtil;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private ClassLoader parent;
    private SecurityManager securityManager;
    private Map<String, byte[]> bytecodes;

    public JasperLoader(URL[] urls, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource, Map<String, byte[]> bytecodes) {
        super(urls, parent);
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.parent = parent;
        this.securityManager = System.getSecurityManager();
        this.bytecodes = bytecodes;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int dot;
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && (dot = name.lastIndexOf(46)) >= 0) {
            try {
                if (!"org.apache.jasper.runtime".equalsIgnoreCase(name.substring(0, dot))) {
                    this.securityManager.checkPackageAccess(name.substring(0, dot));
                }
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                se.printStackTrace();
                throw new ClassNotFoundException(error);
            }
        }
        if (!name.startsWith("org.apache.jsp")) {
            clazz = this.parent.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return this.findClass(name);
    }

    public Class findClass(String className) throws ClassNotFoundException {
        byte[] cdata = this.bytecodes.get(className);
        String path = String.valueOf(className.replace('.', '/')) + ".class";
        if (cdata == null && (cdata = this.loadClassDataFromFile(path)) == null) {
            throw new ClassNotFoundException(className);
        }
        Class<?> clazz = null;
        if (this.securityManager != null) {
            ProtectionDomain pd = new ProtectionDomain(this.codeSource, this.permissionCollection);
            clazz = this.defineClass(className, cdata, 0, cdata.length, pd);
        } else {
            clazz = this.defineClass(className, cdata, 0, cdata.length);
        }
        return clazz;
    }

    private byte[] loadClassDataFromFile(final String fileName) {
        InputStream in;
        byte[] classBytes;
        block4: {
            classBytes = null;
            in = null;
            in = SecurityUtil.isPackageProtectionEnabled() ? AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return JasperLoader.this.getResourceAsStream(fileName);
                }
            }) : this.getResourceAsStream(fileName);
            if (in != null) break block4;
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            in.close();
            baos.close();
            classBytes = baos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return classBytes;
    }

    @Override
    public final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }
}

