/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageAdminServiceTracker
implements ServiceListener {
    private BundleContext _context;
    private List<BundleActivator> _activatedFragments = new ArrayList<BundleActivator>();
    private boolean _fragmentsWereActivated = false;
    public static PackageAdminServiceTracker INSTANCE = null;

    public PackageAdminServiceTracker(BundleContext context) {
        INSTANCE = this;
        this._context = context;
        if (!this.setup()) {
            try {
                this._context.addServiceListener((ServiceListener)this, "(objectclass=" + PackageAdmin.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setup() {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        boolean bl = this._fragmentsWereActivated = sr != null;
        if (sr != null) {
            this.invokeFragmentActivators(sr);
        }
        return this._fragmentsWereActivated;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            this.invokeFragmentActivators(event.getServiceReference());
        }
    }

    public Bundle[] getFragments(Bundle bundle) {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        if (sr == null) {
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        return admin.getFragments(bundle);
    }

    private void invokeFragmentActivators(ServiceReference sr) {
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        Bundle[] fragments = admin.getFragments(this._context.getBundle());
        if (fragments == null) {
            return;
        }
        for (Bundle frag : fragments) {
            try {
                String fragmentActivator = frag.getSymbolicName() + ".FragmentActivator";
                Class<?> c = Class.forName(fragmentActivator);
                if (c == null) continue;
                BundleActivator bActivator = (BundleActivator)c.newInstance();
                bActivator.start(this._context);
                this._activatedFragments.add(bActivator);
            }
            catch (NullPointerException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        INSTANCE = null;
        for (BundleActivator fragAct : this._activatedFragments) {
            try {
                fragAct.stop(this._context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

