/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.osgi.equinoxtools.console.EquinoxChattingSupport;
import org.eclipse.jetty.osgi.equinoxtools.console.EquinoxConsoleContinuationServlet;
import org.eclipse.jetty.osgi.equinoxtools.console.EquinoxConsoleSyncServlet;
import org.eclipse.jetty.osgi.equinoxtools.console.EquinoxConsoleWebSocketServlet;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleSession;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WebEquinoxToolsActivator
implements BundleActivator {
    private static BundleContext context;
    private HttpService _httpService;
    private ServiceTracker _tracker;
    private EquinoxChattingSupport _equinoxChattingSupport;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        ServiceTrackerCustomizer httpServiceTrackerCustomizer = new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference reference, Object service) {
                WebEquinoxToolsActivator.this._httpService = null;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                WebEquinoxToolsActivator.this._httpService = (HttpService)context.getService(reference);
            }

            public Object addingService(ServiceReference reference) {
                WebEquinoxToolsActivator.this._httpService = (HttpService)context.getService(reference);
                try {
                    WebEquinoxToolsActivator.this._httpService.registerResources("/equinoxconsole/ws/index.html", "/equinoxconsole/ws/index.html", null);
                    WebEquinoxToolsActivator.this._httpService.registerServlet("/equinoxconsole/ws", (Servlet)new EquinoxConsoleWebSocketServlet(), null, null);
                    WebEquinoxToolsActivator.this._httpService.registerResources("/equinoxconsole/index.html", "/equinoxconsole/index.html", null);
                    WebEquinoxToolsActivator.this._httpService.registerServlet("/equinoxconsole", (Servlet)new EquinoxConsoleContinuationServlet(), null, null);
                    WebConsoleSession syncSession = new WebConsoleSession();
                    context.registerService(ConsoleSession.class.getName(), (Object)syncSession, null);
                    WebEquinoxToolsActivator.this._httpService.registerServlet("/equinoxconsole/sync", (Servlet)new EquinoxConsoleSyncServlet(syncSession), null, null);
                }
                catch (ServletException e) {
                    Log.warn((Throwable)e);
                }
                catch (NamespaceException e) {
                    Log.warn((Throwable)e);
                }
                return WebEquinoxToolsActivator.this._httpService;
            }
        };
        this._tracker = new ServiceTracker(context, HttpService.class.getName(), httpServiceTrackerCustomizer);
        this._tracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this._tracker.close();
        context = null;
    }
}

