/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools.console;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleSession;

public class EquinoxConsoleSyncServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private WebConsoleSession _consoleSession;

    public EquinoxConsoleSyncServlet(WebConsoleSession consoleSession) {
        this._consoleSession = consoleSession;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cmd = request.getParameter("cmd");
        String Action = request.getParameter("Action");
        if (Action != null && Action.toLowerCase().indexOf("clear") != -1) {
            this._consoleSession.clearOutput();
        }
        if (cmd != null) {
            this._consoleSession.processCommand(cmd, true);
        }
        response.setContentType("text/html;charset=utf-8");
        PrintWriter p = response.getWriter();
        p.println("<html><head><title>Equinox Console (Synchroneous)</title></head><body>");
        p.println("<textarea rows=\"30\" cols=\"110\">");
        p.println(this._consoleSession.getOutputAsWriter().toString());
        p.println("</textarea>");
        p.println("<form method=\"GET\" action=\"" + response.encodeURL(this.getURI(request)) + "\">");
        p.println("osgi>&nbsp;<input type=\"text\" name=\"cmd\" value=\"\"/><br/>\n");
        p.println("<input type=\"submit\" name=\"Action\" value=\"Submit or Refresh\"><br/>");
        p.println("<input type=\"submit\" name=\"Action\" value=\"Clear and Submit\"><br/>");
        p.println("</form>");
        p.println("<br/>");
    }

    private String getURI(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }
}

