/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketGenerator;

public class WebSocketGeneratorD01
implements WebSocketGenerator {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private Buffer _buffer;

    public WebSocketGeneratorD01(WebSocketBuffers buffers, EndPoint endp) {
        this._buffers = buffers;
        this._endp = endp;
    }

    @Override
    public synchronized void addFrame(byte flags, byte opcode, byte[] content, int offset, int length, int blockFor) throws IOException {
        if (this._buffer == null) {
            this._buffer = this._buffers.getDirectBuffer();
        }
        if (this._buffer.space() == 0) {
            this.expelBuffer(blockFor);
        }
        opcode = (byte)(opcode & 0xF);
        while (length > 0) {
            int chunk;
            int fragment = length;
            if (fragment + 10 > this._buffer.capacity()) {
                fragment = this._buffer.capacity() - 10;
                this.bufferPut((byte)(0x80 | opcode), blockFor);
            } else if ((flags & 8) == 0) {
                this.bufferPut(opcode, blockFor);
            } else {
                this.bufferPut((byte)(0x80 | opcode), blockFor);
            }
            if (fragment > 65535) {
                this.bufferPut((byte)127, blockFor);
                this.bufferPut((byte)(fragment >> 56 & 0x7F), blockFor);
                this.bufferPut((byte)(fragment >> 48 & 0xFF), blockFor);
                this.bufferPut((byte)(fragment >> 40 & 0xFF), blockFor);
                this.bufferPut((byte)(fragment >> 32 & 0xFF), blockFor);
                this.bufferPut((byte)(fragment >> 24 & 0xFF), blockFor);
                this.bufferPut((byte)(fragment >> 16 & 0xFF), blockFor);
                this.bufferPut((byte)(fragment >> 8 & 0xFF), blockFor);
                this.bufferPut((byte)(fragment & 0xFF), blockFor);
            } else if (fragment >= 126) {
                this.bufferPut((byte)126, blockFor);
                this.bufferPut((byte)(fragment >> 8), blockFor);
                this.bufferPut((byte)(fragment & 0xFF), blockFor);
            } else {
                this.bufferPut((byte)fragment, blockFor);
            }
            for (int remaining = fragment; remaining > 0; remaining -= chunk) {
                this._buffer.compact();
                chunk = remaining < this._buffer.space() ? remaining : this._buffer.space();
                this._buffer.put(content, offset + (fragment - remaining), chunk);
                if (this._buffer.space() > 0) {
                    this.flushBuffer();
                    continue;
                }
                this.expelBuffer(blockFor);
                if (remaining != 0) continue;
                this.flushBuffer();
            }
            offset += fragment;
            length -= fragment;
        }
    }

    private synchronized void bufferPut(byte datum, long blockFor) throws IOException {
        if (this._buffer == null) {
            this._buffer = this._buffers.getDirectBuffer();
        }
        this._buffer.put(datum);
        if (this._buffer.space() == 0) {
            this.expelBuffer(blockFor);
        }
    }

    @Override
    public synchronized int flush(int blockFor) throws IOException {
        return this.expelBuffer(blockFor);
    }

    @Override
    public synchronized int flush() throws IOException {
        int flushed = this.flushBuffer();
        if (this._buffer != null && this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
        return flushed;
    }

    private synchronized int flushBuffer() throws IOException {
        if (!this._endp.isOpen()) {
            throw new EofException();
        }
        if (this._buffer != null) {
            return this._endp.flush(this._buffer);
        }
        return 0;
    }

    private synchronized int expelBuffer(long blockFor) throws IOException {
        if (this._buffer == null) {
            return 0;
        }
        int result = this.flushBuffer();
        this._buffer.compact();
        if (!this._endp.isBlocking()) {
            while (this._buffer.space() == 0) {
                boolean ready = this._endp.blockWritable(blockFor);
                if (!ready) {
                    throw new IOException("Write timeout");
                }
                result += this.flushBuffer();
                this._buffer.compact();
            }
        }
        return result;
    }

    @Override
    public synchronized boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }
}

