/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.jetty.core.JettyPlugin;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.util.PublishHelper;

public class FileUtil {
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];

    private FileUtil() {
    }

    public static void copyDirectory(String from, String to, IProgressMonitor monitor) {
        try {
            File fromDir = new File(from);
            File toDir = new File(to);
            File[] files = fromDir.listFiles();
            toDir.mkdir();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{from, to}), size * 50);
            int i = 0;
            while (i < size) {
                File current = files[i];
                String fromFile = current.getAbsolutePath();
                String toFile = to;
                if (!toFile.endsWith(File.separator)) {
                    toFile = String.valueOf(toFile) + File.separator;
                }
                toFile = String.valueOf(toFile) + current.getName();
                if (current.isFile()) {
                    FileUtil.copyFile(fromFile, toFile);
                    monitor.worked(50);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{fromFile, toFile}));
                    FileUtil.copyDirectory(fromFile, toFile, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)50));
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error copying directory", e);
        }
    }

    public static IStatus copyFile(InputStream in, String to) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            int avail = in.read(buf);
            while (avail > 0) {
                ((OutputStream)out).write(buf, 0, avail);
                avail = in.read(buf);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error copying file", e);
            Status status = new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
            return status;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                JettyPlugin.log(ex);
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception ex) {
                JettyPlugin.log(ex);
            }
        }
    }

    public static IStatus copyFile(String from, String to) {
        try {
            return FileUtil.copyFile(new FileInputStream(from), to);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error copying file", e);
            return new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public static IStatus copyFile(URL from, String to) {
        try {
            return FileUtil.copyFile(from.openStream(), to);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error copying file", e);
            return new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public static void smartCopyDirectory(String from, String to, IProgressMonitor monitor) {
        try {
            int toSize;
            File fromDir = new File(from);
            File toDir = new File(to);
            File[] fromFiles = fromDir.listFiles();
            int fromSize = fromFiles.length;
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{from, to}), 550);
            File[] toFiles = null;
            if (toDir.exists() && toDir.isDirectory()) {
                toFiles = toDir.listFiles();
                toSize = toFiles.length;
                int i = 0;
                while (i < toSize) {
                    String name = toFiles[i].getName();
                    boolean isDir = toFiles[i].isDirectory();
                    boolean found = false;
                    int j = 0;
                    while (j < fromSize) {
                        if (name.equals(fromFiles[j].getName()) && isDir == fromFiles[j].isDirectory()) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        if (isDir) {
                            PublishHelper.deleteDirectory((File)toFiles[i], null);
                        } else {
                            toFiles[i].delete();
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ++i;
                }
            } else {
                if (toDir.isFile()) {
                    toDir.delete();
                }
                toDir.mkdir();
            }
            monitor.worked(50);
            toFiles = toDir.listFiles();
            toSize = toFiles.length;
            int dw = 0;
            if (toSize > 0) {
                dw = 500 / toSize;
            }
            int i = 0;
            while (i < fromSize) {
                File current = fromFiles[i];
                boolean copy = true;
                if (!current.isDirectory()) {
                    String name = current.getName();
                    long mod = current.lastModified();
                    int j = 0;
                    while (j < toSize) {
                        if (name.equals(toFiles[j].getName()) && mod <= toFiles[j].lastModified()) {
                            copy = false;
                        }
                        ++j;
                    }
                }
                if (copy) {
                    String fromFile = current.getAbsolutePath();
                    String toFile = to;
                    if (!toFile.endsWith(File.separator)) {
                        toFile = String.valueOf(toFile) + File.separator;
                    }
                    toFile = String.valueOf(toFile) + current.getName();
                    if (current.isFile()) {
                        FileUtil.copyFile(fromFile, toFile);
                        monitor.worked(dw);
                    } else if (current.isDirectory()) {
                        monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{fromFile, toFile}));
                        FileUtil.smartCopyDirectory(fromFile, toFile, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)dw));
                    }
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
            monitor.worked(500 - dw * toSize);
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error smart copying directory " + from + " - " + to, e);
        }
    }

    public static String getFileContents(InputStream stream) throws IOException {
        StringBuffer sb;
        block9: {
            BufferedReader br = null;
            sb = new StringBuffer();
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(stream));
                    String temp = br.readLine();
                    while (temp != null) {
                        sb.append(temp).append("\n");
                        temp = br.readLine();
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Could not load file contents.", e);
                    if (br != null) {
                        br.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    br.close();
                }
                throw throwable;
            }
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }
}

