/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.jetty.core.IJettyConfiguration;
import org.eclipse.jst.server.jetty.core.IJettyConfigurationWorkingCopy;
import org.eclipse.jst.server.jetty.core.IJettyServer;
import org.eclipse.jst.server.jetty.core.WebModule;
import org.eclipse.jst.server.jetty.core.internal.FileUtil;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;

public abstract class JettyConfiguration
implements IJettyConfiguration,
IJettyConfigurationWorkingCopy {
    private IFolder _configPath;

    public JettyConfiguration(IFolder path) {
        this._configPath = path;
    }

    protected IFolder getFolder() {
        return this._configPath;
    }

    public ServerPort getMainPort() {
        Collection<ServerPort> serverPorts = this.getServerPorts();
        for (ServerPort serverPort : serverPorts) {
            if (!serverPort.getProtocol().toLowerCase().equals("http") || serverPort.getId().indexOf(47) >= 0) continue;
            return serverPort;
        }
        return null;
    }

    public String getWebModuleURL(IModule webModule) {
        WebModule module = this.getWebModule(webModule);
        if (module != null) {
            return module.getPath();
        }
        IWebModule webModule2 = (IWebModule)webModule.loadAdapter(IWebModule.class, null);
        return "/" + webModule2.getContextRoot();
    }

    public WebModule getWebModule(IModule module) {
        if (module == null) {
            return null;
        }
        String memento = module.getId();
        List<WebModule> modules = this.getWebModules();
        int size = modules.size();
        int i = 0;
        while (i < size) {
            WebModule webModule = modules.get(i);
            if (memento.equals(webModule.getMemento())) {
                return webModule;
            }
            ++i;
        }
        return null;
    }

    public String getDocBasePrefix() {
        return "";
    }

    public IStatus backupAndPublish(IPath jettyDir, boolean doBackup, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.jetty.core", 0, Messages.publishConfigurationTask, null);
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Backup and publish");
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        try {
            IPath backup = null;
            if (doBackup && !(backup = jettyDir.append("backup")).toFile().exists()) {
                backup.toFile().mkdir();
            }
            this.backupFolder(this.getFolder(), jettyDir, backup, ms, monitor);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "backupAndPublish() error", e);
            Status s = new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            ms.add((IStatus)s);
        }
        monitor.done();
        return ms;
    }

    protected void backupFolder(IFolder folder, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IResource[] children = folder.members();
        if (children == null) {
            return;
        }
        IResource resource = null;
        int size = children.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            resource = children[i];
            switch (resource.getType()) {
                case 1: {
                    try {
                        InputStream fis;
                        IFile file = (IFile)resource;
                        String name = file.getName();
                        monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                        if (Trace.isTraceEnabled()) {
                            Trace.trace((byte)4, "Publishing " + name);
                        }
                        boolean copy = true;
                        if (backup != null && !backup.append(name).toFile().exists()) {
                            IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), backup + File.separator + name);
                            ms.add(status);
                            if (!status.isOK()) {
                                copy = false;
                            }
                        }
                        if (!copy) break;
                        String destPath = confDir.append(name).toOSString();
                        String destContents = null;
                        String srcContents = null;
                        File dest = new File(destPath);
                        if (dest.exists() && (destContents = FileUtil.getFileContents(fis = new FileInputStream(destPath))) != null) {
                            fis = file.getContents();
                            srcContents = FileUtil.getFileContents(fis);
                        }
                        if (destContents != null && srcContents != null && srcContents.equals(destContents)) break;
                        InputStream in = file.getContents();
                        ms.add(FileUtil.copyFile(in, destPath));
                    }
                    catch (Exception e) {
                        Trace.trace((byte)3, "backupAndPublish() error", e);
                        ms.add((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
                    }
                    break;
                }
                case 2: {
                    IFolder childFolder = (IFolder)resource;
                    this.backupFolder(childFolder, confDir.append(childFolder.getName()), backup != null ? backup.append(childFolder.getName()) : null, ms, monitor);
                }
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected void backupPath(IPath path, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) {
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return;
        }
        int size = files.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            try {
                File file = files[i];
                String name = file.getName();
                monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)4, "Publishing " + name);
                }
                boolean copy = true;
                if (backup != null && !backup.append(name).toFile().exists()) {
                    IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), backup + File.separator + name);
                    ms.add(status);
                    if (!status.isOK()) {
                        copy = false;
                    }
                }
                if (copy) {
                    ms.add(FileUtil.copyFile(file.getAbsolutePath(), confDir.append(name).toOSString()));
                }
            }
            catch (Exception e) {
                Trace.trace((byte)3, "backupAndPublish() error", e);
                ms.add((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
            }
            monitor.worked(100);
            ++i;
        }
    }

    public IStatus cleanupServer(IPath confDir, IPath installDir, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public IStatus localizeConfiguration(IPath confDir, IPath serverDeployDirectory, IJettyServer jettyServer, IProgressMonitor subMonitorFor) {
        return Status.OK_STATUS;
    }
}

