/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.net.URL;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.jst.server.jetty.core.JettyPlugin;
import org.eclipse.jst.server.jetty.core.internal.JettyServer;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class JettyLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    private static final String __SERVLET_PATH = "servlet/";

    public Object getLaunchable(IServer server, IModuleArtifact moduleObject) {
        Trace.trace((byte)4, "JettyLaunchableAdapter " + server + "-" + moduleObject);
        if (server.getAdapter(JettyServer.class) == null) {
            return null;
        }
        if (!(moduleObject instanceof Servlet) && !(moduleObject instanceof WebResource)) {
            return null;
        }
        if (moduleObject.getModule().loadAdapter(IWebModule.class, null) == null) {
            return null;
        }
        try {
            URL url = ((IURLProvider)server.loadAdapter(IURLProvider.class, null)).getModuleRootURL(moduleObject.getModule());
            Trace.trace((byte)4, "root: " + url);
            if (moduleObject instanceof Servlet) {
                Servlet servlet = (Servlet)moduleObject;
                if (servlet.getAlias() != null) {
                    String path = servlet.getAlias();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = new URL(url, path);
                } else {
                    url = new URL(url, __SERVLET_PATH + servlet.getServletClassName());
                }
            } else if (moduleObject instanceof WebResource) {
                WebResource resource = (WebResource)moduleObject;
                String path = resource.getPath().toString();
                Trace.trace((byte)4, "path: " + path);
                if (path != null && path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (path != null && path.length() > 0) {
                    url = new URL(url, path);
                }
            }
            return new HttpLaunchable(url);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error getting URL for " + moduleObject, e);
            JettyPlugin.log(e);
            return null;
        }
    }
}

