/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.jetty.core.IJettyRuntimeWorkingCopy;
import org.eclipse.jst.server.jetty.core.JettyPlugin;
import org.eclipse.jst.server.jetty.core.internal.IJettyRuntime;
import org.eclipse.jst.server.jetty.core.internal.IJettyVersionHandler;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.jst.server.jetty.core.internal.util.StringUtils;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyRuntime
extends RuntimeDelegate
implements IJettyRuntime,
IJettyRuntimeWorkingCopy {
    private static final String __JAVAC_MAIN = "com.sun.tools.javac.Main";
    private static final String __CLASS_DETECTOR = "org.eclipse.jst.server.jetty.core.internal.ClassDetector";
    protected static final String __PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String __PROP_VM_INSTALL_ID = "vm-install-id";
    protected static final Map<File, Boolean> __SDK_MAP = new HashMap<File, Boolean>(2);
    private static Map<String, Integer> __JAVA_VERSION_MAP = new ConcurrentHashMap<String, Integer>();

    public IJettyVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return JettyPlugin.getJettyVersionHandler(type.getId());
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(__PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(__PROP_VM_INSTALL_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            JettyPlugin.log(e);
        }
        return null;
    }

    @Override
    public Collection<IRuntimeClasspathEntry> getRuntimeClasspath(IPath configPath) {
        IPath installPath = this.getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException e) {
                JettyPlugin.log(e);
            }
        }
        return this.getVersionHandler().getRuntimeClasspath(installPath, configPath);
    }

    public IStatus verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = this.verifyLocation();
        if (!status.isOK()) {
            return status;
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "org.eclipse.jst.server.jetty.core", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.jetty.core", 0, Messages.errorJRE, null);
        }
        status = this.getVersionHandler().validate(this.getRuntime().getLocation(), this.getVMInstall());
        if (status != null) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        IRuntimeType type = this.getRuntimeWorkingCopy().getRuntimeType();
        this.getRuntimeWorkingCopy().setLocation((IPath)new Path(JettyPlugin.getPreference("location" + type.getId())));
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(__PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(__PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(__PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(__PROP_VM_INSTALL_ID, id);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean checkForCompiler() {
        File javaHome;
        block22: {
            Launch launch;
            block23: {
                boolean bl;
                javaHome = this.getVMInstall().getInstallLocation();
                try {
                    Boolean b = __SDK_MAP.get(javaHome);
                    return b;
                }
                catch (Exception exception) {
                    File file = JettyPlugin.getPlugin();
                    if (file == null || !file.exists()) break block22;
                    IVMRunner vmRunner = this.getVMInstall().getVMRunner("run");
                    VMRunnerConfiguration config = new VMRunnerConfiguration(__CLASS_DETECTOR, new String[]{file.getAbsolutePath()});
                    config.setProgramArguments(new String[]{__JAVAC_MAIN});
                    launch = new Launch(null, "run", null);
                    vmRunner.run(config, (ILaunch)launch, null);
                    int i = 0;
                    while (i < 600) {
                        if (launch.isTerminated()) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                    IStreamsProxy streamsProxy = launch.getProcesses()[0].getStreamsProxy();
                    String text = null;
                    if (streamsProxy == null || (text = streamsProxy.getOutputStreamMonitor().getContents()) == null || text.length() <= 0) break block23;
                    boolean found = false;
                    if (StringUtils.isTrue(text)) {
                        found = true;
                    }
                    __SDK_MAP.put(javaHome, found);
                    bl = found;
                }
                if (!launch.isTerminated()) {
                    try {
                        launch.terminate();
                    }
                    catch (Exception exception) {}
                }
                return bl;
                {
                    catch (Exception e) {
                        try {
                            Trace.trace((byte)3, "Error checking for JDK", e);
                        }
                        catch (Throwable throwable) {
                            if (!launch.isTerminated()) {
                                try {
                                    launch.terminate();
                                }
                                catch (Exception exception) {}
                            }
                            throw throwable;
                        }
                        if (!launch.isTerminated()) {
                            try {
                                launch.terminate();
                            }
                            catch (Exception exception) {}
                        }
                        break block22;
                    }
                }
            }
            if (!launch.isTerminated()) {
                try {
                    launch.terminate();
                }
                catch (Exception exception) {}
            }
        }
        JettyPlugin.log(MessageFormat.format("Failed compiler check for {0}", javaHome.getAbsolutePath()));
        return false;
    }

    private boolean isVMMinimumVersion(String javaVersion, int minimumVersion) {
        int index;
        Integer version = __JAVA_VERSION_MAP.get(javaVersion);
        if (version == null && (index = javaVersion.indexOf(46)) > 0) {
            try {
                int major = Integer.parseInt(javaVersion.substring(0, index)) * 100;
                int index2 = javaVersion.indexOf(46, ++index);
                if (index2 > 0) {
                    int minor = Integer.parseInt(javaVersion.substring(index, index2));
                    version = major + minor;
                    __JAVA_VERSION_MAP.put(javaVersion, version);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return version == null || version >= minimumVersion;
    }
}

