/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.jst.server.jetty.core.IJettyConfiguration;
import org.eclipse.jst.server.jetty.core.IJettyServer;
import org.eclipse.jst.server.jetty.core.IJettyServerWorkingCopy;
import org.eclipse.jst.server.jetty.core.JettyPlugin;
import org.eclipse.jst.server.jetty.core.WebModule;
import org.eclipse.jst.server.jetty.core.internal.IJettyVersionHandler;
import org.eclipse.jst.server.jetty.core.internal.JettyRuntime;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class JettyServer
extends ServerDelegate
implements IJettyServer,
IJettyServerWorkingCopy {
    private static final ServerPort[] _EMPTY_SERVER_PORTS = new ServerPort[0];
    public static final String __PROPERTY_SECURE = "secure";
    public static final String __PROPERTY_DEBUG = "debug";
    private static final String __JST_WEB_MODULETYPE = "jst.web";
    private static final IModule[] __EMPTY_MODULES = new IModule[0];
    protected transient IJettyConfiguration _configuration;
    protected transient IJettyVersionHandler _versionHandler;

    public JettyRuntime getJettyRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (JettyRuntime)this.getServer().getRuntime().loadAdapter(JettyRuntime.class, null);
    }

    public IJettyVersionHandler getJettyVersionHandler() {
        if (this._versionHandler == null) {
            if (this.getServer().getRuntime() == null || this.getJettyRuntime() == null) {
                return null;
            }
            this._versionHandler = this.getJettyRuntime().getVersionHandler();
        }
        return this._versionHandler;
    }

    public IJettyConfiguration getJettyConfiguration() throws CoreException {
        if (this._configuration == null) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                    IProject project = folder.getProject();
                    if (project != null && project.exists() && !project.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorConfigurationProjectClosed, (Object)path, (Object)project.getName()), null));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorNoConfiguration, (Object)path), null));
            }
            String id = this.getServer().getServerType().getId();
            this._configuration = JettyPlugin.getJettyConfiguration(id, folder);
            try {
                this._configuration.load(folder, this.getRuntimeBaseDirectory(), null);
            }
            catch (CoreException ce) {
                this._configuration = null;
                throw ce;
            }
        }
        return this._configuration;
    }

    public void configurationChanged() {
        this._configuration = null;
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (runtime == null) {
            this._configuration = null;
            return;
        }
        IPath path = runtime.getLocation();
        String id = this.getServer().getServerType().getId();
        IPath runtimeBaseDirectory = this.getRuntimeBaseDirectory();
        IFolder folder = this.getServer().getServerConfiguration();
        this._configuration = JettyPlugin.getJettyConfiguration(id, folder);
        try {
            this._configuration.importFromPath(path, runtimeBaseDirectory, this.isTestEnvironment(), monitor);
        }
        catch (CoreException ce) {
            this._configuration = null;
            throw ce;
        }
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        if (this._configuration == null) {
            return;
        }
        this._configuration.save(this.getServer().getServerConfiguration(), monitor);
    }

    public ServerPort[] getServerPorts() {
        if (this.getServer().getServerConfiguration() == null) {
            return _EMPTY_SERVER_PORTS;
        }
        try {
            Collection<ServerPort> list = this.getJettyConfiguration().getServerPorts();
            ServerPort[] sp = new ServerPort[list.size()];
            list.toArray(sp);
            return sp;
        }
        catch (Exception exception) {
            return _EMPTY_SERVER_PORTS;
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setTestEnvironment(true);
        this.setAttribute("auto-publish-setting", 2);
        this.setAttribute("auto-publish-time", 1);
        this.setDeployDirectory("wtpwebapps");
    }

    public void setDebug(boolean b) {
        this.setAttribute(__PROPERTY_DEBUG, b);
    }

    public void setSecure(boolean b) {
        this.setAttribute(__PROPERTY_SECURE, b);
    }

    public void setTestEnvironment(boolean b) {
        this.setAttribute("testEnvironment", b);
    }

    public void setInstanceDirectory(String instanceDir) {
        this.setAttribute("instanceDir", instanceDir);
    }

    public void setDeployDirectory(String deployDir) {
        if ("webapps".equalsIgnoreCase(deployDir)) {
            this.setAttribute("deployDir", null);
        } else {
            this.setAttribute("deployDir", deployDir);
        }
    }

    public IPath getRuntimeBaseDirectory() {
        IJettyVersionHandler tvh = this.getJettyVersionHandler();
        if (tvh != null) {
            return tvh.getRuntimeBaseDirectory(this);
        }
        return null;
    }

    public IPath getServerDeployDirectory() {
        String deployDir = this.getDeployDirectory();
        Path deployPath = new Path(deployDir);
        if (!deployPath.isAbsolute()) {
            IPath base = this.getRuntimeBaseDirectory();
            deployPath = base.append((IPath)deployPath);
        }
        return deployPath;
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                if (!__JST_WEB_MODULETYPE.equals(module.getModuleType().getId())) {
                    return new Status(4, "org.eclipse.jst.server.jetty.core", 0, Messages.errorWebModulesOnly, null);
                }
                if (this.getJettyVersionHandler() == null) {
                    return new Status(4, "org.eclipse.jst.server.jetty.core", 0, Messages.errorNoRuntime, null);
                }
                IStatus status = this.getJettyVersionHandler().canAddModule(module);
                if (status != null && !status.isOK()) {
                    return status;
                }
                if (module.getProject() != null && (status = FacetUtil.verifyFacets((IProject)module.getProject(), (IServer)this.getServer())) != null && !status.isOK()) {
                    return status;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IModule module3;
        IStatus status = this.canModifyModules(add, remove);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
        IJettyConfiguration config = this.getJettyConfiguration();
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                module3 = add[i];
                IWebModule module = (IWebModule)module3.loadAdapter(IWebModule.class, monitor);
                String contextRoot = module.getContextRoot();
                if (contextRoot != null && !contextRoot.startsWith("/") && contextRoot.length() > 0) {
                    contextRoot = "/" + contextRoot;
                }
                String docBase = String.valueOf(config.getDocBasePrefix()) + module3.getName();
                WebModule module2 = new WebModule(contextRoot, docBase, module3.getId(), true);
                config.addWebModule(-1, module2);
                ++i;
            }
        }
        if (remove != null) {
            int size2 = remove.length;
            int j = 0;
            while (j < size2) {
                module3 = remove[j];
                String memento = module3.getId();
                List<WebModule> modules = this.getJettyConfiguration().getWebModules();
                int size = modules.size();
                int i = 0;
                while (i < size) {
                    WebModule module = modules.get(i);
                    if (memento.equals(module.getMemento())) {
                        config.removeWebModule(i);
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public IModule[] getChildModules(IModule[] module) {
        IWebModule webModule;
        if (module == null) {
            return null;
        }
        IModuleType moduleType = module[0].getModuleType();
        if (module.length == 1 && moduleType != null && __JST_WEB_MODULETYPE.equals(moduleType.getId()) && (webModule = (IWebModule)module[0].loadAdapter(IWebModule.class, null)) != null) {
            IModule[] modules = webModule.getModules();
            return modules;
        }
        return __EMPTY_MODULES;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (__JST_WEB_MODULETYPE.equals(module.getModuleType().getId())) {
            IStatus status = this.canModifyModules(new IModule[]{module}, null);
            if (status == null || !status.isOK()) {
                throw new CoreException(status);
            }
            return new IModule[]{module};
        }
        return J2EEUtil.getWebModules((IModule)module, null);
    }

    public URL getModuleRootURL(IModule module) {
        IJettyConfiguration config;
        block7: {
            block6: {
                try {
                    if (module != null) break block6;
                    return null;
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Could not get root URL", e);
                    return null;
                }
            }
            config = this.getJettyConfiguration();
            if (config != null) break block7;
            return null;
        }
        String url = "http://" + this.getServer().getHost();
        int port = config.getMainPort().getPort();
        port = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port, (String)"web");
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        if (!(url = String.valueOf(url) + config.getWebModuleURL(module)).endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        return new URL(url);
    }

    public boolean isDebug() {
        return this.getAttribute(__PROPERTY_DEBUG, false);
    }

    public boolean isTestEnvironment() {
        return this.getAttribute("testEnvironment", false);
    }

    public boolean isSecure() {
        return this.getAttribute(__PROPERTY_SECURE, false);
    }

    public String getInstanceDirectory() {
        return this.getAttribute("instanceDir", null);
    }

    public String getDeployDirectory() {
        return this.getAttribute("deployDir", "webapps");
    }

    public boolean isServeModulesWithoutPublish() {
        IJettyVersionHandler tvh = this.getJettyVersionHandler();
        if (tvh != null && tvh.supportsServeModulesWithoutPublish()) {
            return this.getAttribute("serveModulesWithoutPublish", false);
        }
        return false;
    }

    public IJettyConfiguration getServerConfiguration() throws CoreException {
        return this.getJettyConfiguration();
    }
}

