/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.jetty.core.IJettyConfiguration;
import org.eclipse.jst.server.jetty.core.JettyPlugin;
import org.eclipse.jst.server.jetty.core.WebModule;
import org.eclipse.jst.server.jetty.core.internal.IJettyServerBehaviour;
import org.eclipse.jst.server.jetty.core.internal.IJettyVersionHandler;
import org.eclipse.jst.server.jetty.core.internal.JettyRuntime;
import org.eclipse.jst.server.jetty.core.internal.JettyServer;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.jst.server.jetty.core.internal.PingThread;
import org.eclipse.jst.server.jetty.core.internal.PublishOperation2;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.jst.server.jetty.core.internal.util.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IModulePublishHelper;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.eclipse.wst.server.core.util.SocketUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyServerBehaviour
extends ServerBehaviourDelegate
implements IJettyServerBehaviour,
IModulePublishHelper {
    private static final String __ATTR_STOP = "stop-server";
    private static final String[] __JMX_EXCLUDE_ARGS = new String[]{"-Dcom.sun.management.jmxremote", "-Dcom.sun.management.jmxremote.port=", "-Dcom.sun.management.jmxremote.ssl=", "-Dcom.sun.management.jmxremote.authenticate="};
    protected transient PingThread _ping = null;
    protected transient IDebugEventSetListener _processListener;

    public void initialize(IProgressMonitor monitor) {
    }

    public JettyRuntime getJettyRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (JettyRuntime)this.getServer().getRuntime().loadAdapter(JettyRuntime.class, null);
    }

    public IJettyVersionHandler getJettyVersionHandler() {
        return this.getJettyServer().getJettyVersionHandler();
    }

    public IJettyConfiguration getJettyConfiguration() throws CoreException {
        return this.getJettyServer().getJettyConfiguration();
    }

    public JettyServer getJettyServer() {
        return (JettyServer)this.getServer().loadAdapter(JettyServer.class, null);
    }

    @Override
    public String getRuntimeClass() {
        return this.getJettyVersionHandler().getRuntimeClass();
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getJettyServer().getRuntimeBaseDirectory();
    }

    protected String[] getRuntimeProgramArguments(boolean starting) {
        IPath configPath = null;
        if (this.getJettyServer().isTestEnvironment()) {
            configPath = this.getRuntimeBaseDirectory();
        }
        return this.getJettyVersionHandler().getRuntimeProgramArguments(configPath, this.getJettyServer().isDebug(), starting);
    }

    protected String[] getExcludedRuntimeProgramArguments(boolean starting) {
        return this.getJettyVersionHandler().getExcludedRuntimeProgramArguments(this.getJettyServer().isDebug(), starting);
    }

    protected String[] getRuntimeVMArguments() {
        IPath deployPath;
        IPath installPath = this.getServer().getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        IPath configPath = this.getRuntimeBaseDirectory();
        if (this.getJettyServer().isServeModulesWithoutPublish()) {
            deployPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        } else {
            deployPath = this.getServerDeployDirectory();
            if (!deployPath.isAbsolute()) {
                try {
                    String deployLoc = new File(deployPath.toOSString()).getCanonicalPath();
                    deployPath = new Path(deployLoc);
                }
                catch (IOException iOException) {}
            }
        }
        int mainPort = 8080;
        int adminPort = 8082;
        try {
            IJettyConfiguration config = this.getJettyConfiguration();
            mainPort = config.getMainPort().getPort();
            adminPort = config.getAdminPort().getPort();
        }
        catch (CoreException coreException) {}
        return this.getJettyVersionHandler().getRuntimeVMArguments(installPath, configPath, deployPath, mainPort, adminPort, this.getJettyServer().isTestEnvironment());
    }

    protected String getRuntimePolicyFile() {
        IPath configPath = this.getRuntimeBaseDirectory();
        return this.getJettyVersionHandler().getRuntimePolicyFile(configPath);
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    @Override
    public void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if (StringUtils.isTrue(launch.getLaunchConfiguration().getAttribute(__ATTR_STOP, "false"))) {
            return;
        }
        IStatus status = this.getJettyRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        IJettyConfiguration configuration = this.getJettyConfiguration();
        Iterator<Object> iterator = configuration.getServerPorts().iterator();
        ArrayList<ServerPort> usedPorts = new ArrayList<ServerPort>();
        while (iterator.hasNext()) {
            ServerPort sp = iterator.next();
            if (sp.getPort() < 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, Messages.errorPortInvalid, null));
            }
            if (!SocketUtil.isPortInUse((int)sp.getPort(), (int)5)) continue;
            usedPorts.add(sp);
        }
        if (usedPorts.size() == 1) {
            ServerPort port = (ServerPort)usedPorts.get(0);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port.getPort()), this.getServer().getName()}), null));
        }
        if (usedPorts.size() > 1) {
            String portStr = "";
            iterator = usedPorts.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    portStr = String.valueOf(portStr) + ", ";
                }
                first = false;
                ServerPort sp = (ServerPort)iterator.next();
                portStr = String.valueOf(portStr) + sp.getPort();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorPortsInUse, (Object[])new String[]{portStr, this.getServer().getName()}), null));
        }
        Iterator<WebModule> wmIterator = configuration.getWebModules().iterator();
        ArrayList<String> contextRoots = new ArrayList<String>();
        while (iterator.hasNext()) {
            WebModule module = wmIterator.next();
            String contextRoot = module.getPath();
            if (contextRoots.contains(contextRoot)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorDuplicateContextRoot, (Object[])new String[]{contextRoot}), null));
            }
            contextRoots.add(contextRoot);
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://" + this.getServer().getHost();
            int port = configuration.getMainPort().getPort();
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this._ping = new PingThread(this.getServer(), url, -1, this);
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Can't ping for Jetty startup.");
        }
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4 || state == 3) {
            return;
        }
        if (state == 1) {
            this.terminate();
            return;
        }
        try {
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Stopping Jetty");
            }
            if (state != 4) {
                this.setServerState(3);
            }
            ILaunchConfiguration launchConfig = ((Server)this.getServer()).getLaunchConfiguration(true, null);
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            String args = JettyServerBehaviour.renderCommandLine(this.getRuntimeProgramArguments(false), " ");
            String existingVMArgs = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            if (existingVMArgs.indexOf(__JMX_EXCLUDE_ARGS[0]) >= 0) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, JettyServerBehaviour.mergeArguments(existingVMArgs, new String[0], __JMX_EXCLUDE_ARGS, false));
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute(__ATTR_STOP, "true");
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error stopping Jetty", e);
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            ILaunch launch;
            this.setServerState(3);
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Killing the Jetty process");
            }
            if ((launch = this.getServer().getLaunch()) != null) {
                launch.terminate();
                this.stopImpl();
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error killing the process", e);
        }
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory(false);
    }

    protected static int getNextToken(String s, int start) {
        int i = start;
        int length = s.length();
        int lookFor = 32;
        while (i < length) {
            int c = s.charAt(i);
            if (lookFor == c) {
                if (lookFor == 34) {
                    return i + 1;
                }
                return i;
            }
            if (c == 34) {
                lookFor = 34;
            }
            ++i;
        }
        return -1;
    }

    public static String mergeArguments(String originalArg, String[] vmArgs, String[] excludeArgs, boolean keepActionLast) {
        int index2;
        String s;
        int index;
        int ind2;
        int ind;
        if (vmArgs == null) {
            return originalArg;
        }
        if (originalArg == null) {
            originalArg = "";
        }
        int size = vmArgs.length;
        int i = 0;
        while (i < size) {
            ind = vmArgs[i].indexOf(" ");
            ind2 = vmArgs[i].indexOf("=");
            if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                index = originalArg.indexOf(vmArgs[i].substring(0, ind + 1));
                if (index == 0 || index > 0 && Character.isWhitespace(originalArg.charAt(index - 1))) {
                    s = originalArg.substring(0, index);
                    index2 = JettyServerBehaviour.getNextToken(originalArg, index + ind + 1);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            } else if (ind2 >= 0) {
                index = originalArg.indexOf(vmArgs[i].substring(0, ind2 + 1));
                if (index == 0 || index > 0 && Character.isWhitespace(originalArg.charAt(index - 1))) {
                    s = originalArg.substring(0, index);
                    index2 = JettyServerBehaviour.getNextToken(originalArg, index);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            } else {
                index = originalArg.indexOf(vmArgs[i]);
                if (index == 0 || index > 0 && Character.isWhitespace(originalArg.charAt(index - 1))) {
                    s = originalArg.substring(0, index);
                    index2 = JettyServerBehaviour.getNextToken(originalArg, index);
                    if (!keepActionLast || i < size - 1) {
                        originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                        vmArgs[i] = null;
                    } else {
                        originalArg = index2 >= 0 ? String.valueOf(s) + originalArg.substring(index2) : s;
                    }
                }
            }
            ++i;
        }
        if (excludeArgs != null && excludeArgs.length > 0) {
            i = 0;
            while (i < excludeArgs.length) {
                ind = excludeArgs[i].indexOf(" ");
                ind2 = excludeArgs[i].indexOf("=");
                if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                    index = originalArg.indexOf(excludeArgs[i].substring(0, ind + 1));
                    if (index == 0 || index > 0 && Character.isWhitespace(originalArg.charAt(index - 1))) {
                        s = originalArg.substring(0, index);
                        index2 = JettyServerBehaviour.getNextToken(originalArg, index + ind + 1);
                        if (index2 >= 0) {
                            while (index2 < originalArg.length() && Character.isWhitespace(originalArg.charAt(index2))) {
                                ++index2;
                            }
                            originalArg = String.valueOf(s) + originalArg.substring(index2);
                        } else {
                            originalArg = s;
                        }
                    }
                } else if (ind2 >= 0) {
                    index = originalArg.indexOf(excludeArgs[i].substring(0, ind2 + 1));
                    if (index == 0 || index > 0 && Character.isWhitespace(originalArg.charAt(index - 1))) {
                        s = originalArg.substring(0, index);
                        index2 = JettyServerBehaviour.getNextToken(originalArg, index);
                        if (index2 >= 0) {
                            while (index2 < originalArg.length() && Character.isWhitespace(originalArg.charAt(index2))) {
                                ++index2;
                            }
                            originalArg = String.valueOf(s) + originalArg.substring(index2);
                        } else {
                            originalArg = s;
                        }
                    }
                } else {
                    index = originalArg.indexOf(excludeArgs[i]);
                    if (index == 0 || index > 0 && Character.isWhitespace(originalArg.charAt(index - 1))) {
                        s = originalArg.substring(0, index);
                        index2 = JettyServerBehaviour.getNextToken(originalArg, index);
                        if (index2 >= 0) {
                            while (index2 < originalArg.length() && Character.isWhitespace(originalArg.charAt(index2))) {
                                ++index2;
                            }
                            originalArg = String.valueOf(s) + originalArg.substring(index2);
                        } else {
                            originalArg = s;
                        }
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            if (vmArgs[i] != null) {
                if (originalArg.length() > 0 && !originalArg.endsWith(" ")) {
                    originalArg = String.valueOf(originalArg) + " ";
                }
                originalArg = String.valueOf(originalArg) + vmArgs[i];
            }
            ++i;
        }
        return originalArg;
    }

    public static void replaceJREContainer(List<IRuntimeClasspathEntry> cp, IRuntimeClasspathEntry entry) {
        int size = cp.size();
        int i = 0;
        while (i < size) {
            IRuntimeClasspathEntry entry2 = cp.get(i);
            if (entry2.getPath().uptoSegment(2).isPrefixOf(entry.getPath())) {
                cp.set(i, entry);
                return;
            }
            ++i;
        }
        cp.add(0, entry);
    }

    public static void mergeClasspath(List<IRuntimeClasspathEntry> cp, IRuntimeClasspathEntry entry) {
        for (IRuntimeClasspathEntry entry2 : cp) {
            if (!entry2.getPath().equals((Object)entry.getPath())) continue;
            return;
        }
        cp.add(entry);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        String existingProgArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, JettyServerBehaviour.mergeArguments(existingProgArgs, this.getRuntimeProgramArguments(true), this.getExcludedRuntimeProgramArguments(true), true));
        String existingVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        String[] parsedVMArgs = null;
        if (existingVMArgs != null) {
            parsedVMArgs = DebugPlugin.parseArguments((String)existingVMArgs);
        }
        String[] configVMArgs = this.getRuntimeVMArguments();
        if (this.getJettyServer().isSecure()) {
            boolean addSecurityArgs = true;
            if (parsedVMArgs != null) {
                int i = 0;
                while (i < parsedVMArgs.length) {
                    if (parsedVMArgs[i].startsWith("wtp.configured.security")) {
                        addSecurityArgs = false;
                        break;
                    }
                    ++i;
                }
            }
            if (addSecurityArgs) {
                String[] newVMArgs = new String[configVMArgs.length + 3];
                System.arraycopy(configVMArgs, 0, newVMArgs, 0, configVMArgs.length);
                newVMArgs[configVMArgs.length] = "-Djava.security.manager";
                newVMArgs[configVMArgs.length + 1] = "-Djava.security.policy=\"" + this.getRuntimePolicyFile() + "\"";
                newVMArgs[configVMArgs.length + 2] = "-Dwtp.configured.security=true";
                configVMArgs = newVMArgs;
            }
        } else if (parsedVMArgs != null) {
            boolean removeSecurityArgs = false;
            int i = 0;
            while (i < parsedVMArgs.length) {
                if (parsedVMArgs[i].startsWith("-Dwtp.configured.security")) {
                    removeSecurityArgs = true;
                    break;
                }
                ++i;
            }
            if (removeSecurityArgs) {
                StringBuffer filteredVMArgs = new StringBuffer();
                int i2 = 0;
                while (i2 < parsedVMArgs.length) {
                    String arg = parsedVMArgs[i2];
                    if (!(arg.startsWith("-Djava.security.manager") || arg.startsWith("-Djava.security.policy=") || arg.startsWith("-Dwtp.configured.security="))) {
                        if (filteredVMArgs.length() > 0) {
                            filteredVMArgs.append(' ');
                        }
                        filteredVMArgs.append(arg);
                    }
                    ++i2;
                }
                existingVMArgs = filteredVMArgs.toString();
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, JettyServerBehaviour.mergeArguments(existingVMArgs, configVMArgs, null, false));
        JettyRuntime runtime = this.getJettyRuntime();
        IVMInstall vmInstall = runtime.getVMInstall();
        if (vmInstall != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        IRuntimeClasspathEntry[] originalClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
        int size = originalClasspath.length;
        ArrayList<IRuntimeClasspathEntry> oldCp = new ArrayList<IRuntimeClasspathEntry>(originalClasspath.length + 2);
        int i = 0;
        while (i < size) {
            oldCp.add(originalClasspath[i]);
            ++i;
        }
        Collection<IRuntimeClasspathEntry> cp2 = runtime.getRuntimeClasspath(this.getRuntimeBaseDirectory());
        for (IRuntimeClasspathEntry entry : cp2) {
            JettyServerBehaviour.mergeClasspath(oldCp, entry);
        }
        if (vmInstall != null) {
            try {
                String typeId = vmInstall.getVMInstallType().getId();
                JettyServerBehaviour.replaceJREContainer(oldCp, JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2));
            }
            catch (Exception e) {
                JettyPlugin.log(e);
            }
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            IPath toolsPath = jrePath.append("lib").append("tools.jar");
            if (toolsPath.toFile().exists()) {
                IRuntimeClasspathEntry toolsJar = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath);
                int toolsIndex = 0;
                while (toolsIndex < oldCp.size()) {
                    IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)oldCp.get(toolsIndex);
                    if (entry.getType() == 2 && entry.getPath().lastSegment().equals("tools.jar")) break;
                    ++toolsIndex;
                }
                if (toolsIndex < oldCp.size()) {
                    oldCp.set(toolsIndex, toolsJar);
                } else {
                    JettyServerBehaviour.mergeClasspath(oldCp, toolsJar);
                }
            }
        }
        Iterator<Object> iterator = oldCp.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            try {
                list.add(entry.getMemento());
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Could not resolve classpath entry: " + entry, e);
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, list);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    protected void addProcessListener(final IProcess newProcess) {
        if (this._processListener != null || newProcess == null) {
            return;
        }
        this._processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (newProcess != null && newProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            JettyServerBehaviour.this.stopImpl();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this._processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void stopImpl() {
        if (this._ping != null) {
            this._ping.stop();
            this._ping = null;
        }
        if (this._processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this._processListener);
            this._processListener = null;
        }
        this.setServerState(4);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath installDir = this.getServer().getRuntime().getLocation();
        IPath confDir = null;
        if (this.getJettyServer().isTestEnvironment()) {
            confDir = this.getRuntimeBaseDirectory();
            status = this.getJettyVersionHandler().prepareRuntimeDirectory(confDir);
            if (status != null && !status.isOK()) {
                throw new CoreException(status);
            }
        } else {
            confDir = installDir;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        status = this.getJettyConfiguration().cleanupServer(confDir, installDir, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getJettyConfiguration().backupAndPublish(confDir, !this.getJettyServer().isTestEnvironment(), ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)400));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getJettyConfiguration().localizeConfiguration(confDir, this.getServerDeployDirectory(), this.getJettyServer(), ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        if (this.getJettyServer().isTestEnvironment()) {
            return;
        }
        Properties p = this.loadModulePublishLocations();
        PublishHelper helper = new PublishHelper(this.getRuntimeBaseDirectory().append("temp").toFile());
        if (moduleTree.length == 1) {
            this.publishDir(deltaKind, p, moduleTree, helper, monitor);
        } else {
            IWebModule webModule = (IWebModule)moduleTree[0].loadAdapter(IWebModule.class, monitor);
            String childURI = null;
            if (webModule != null) {
                childURI = webModule.getURI(moduleTree[1]);
            }
            IJ2EEModule childModule = (IJ2EEModule)moduleTree[1].loadAdapter(IJ2EEModule.class, monitor);
            boolean isBinary = false;
            if (childModule != null) {
                isBinary = childModule.isBinary();
            }
            if (isBinary) {
                this.publishArchiveModule(childURI, kind, deltaKind, p, moduleTree, helper, monitor);
            } else {
                this.publishJar(childURI, kind, deltaKind, p, moduleTree, helper, monitor);
            }
        }
        this.setModulePublishState(moduleTree, 1);
        this.saveModulePublishLocations(p);
    }

    private void publishDir(int deltaKind, Properties p, IModule[] module, PublishHelper helper, IProgressMonitor monitor) throws CoreException {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (deltaKind == 3 || this.getJettyServer().isServeModulesWithoutPublish()) {
            String publishPath = (String)p.get(module[0].getId());
            if (publishPath != null) {
                try {
                    File f = new File(publishPath);
                    if (f.exists()) {
                        IStatus[] stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                        PublishOperation2.addArrayToList(status, stat);
                    }
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorPublishCouldNotRemoveModule, (Object)module[0].getName()), (Throwable)e));
                }
                p.remove(module[0].getId());
            }
        } else {
            IPath path = this.getModuleDeployDirectory(module[0]);
            IModuleResource[] mr = this.getResources(module);
            IPath[] jarPaths = null;
            IWebModule webModule = (IWebModule)module[0].loadAdapter(IWebModule.class, monitor);
            IModule[] childModules = this.getServer().getChildModules(module, monitor);
            if (childModules != null && childModules.length > 0) {
                jarPaths = new IPath[childModules.length];
                int i = 0;
                while (i < childModules.length) {
                    IJ2EEModule childModule;
                    jarPaths[i] = webModule != null ? new Path(webModule.getURI(childModules[i])) : ((childModule = (IJ2EEModule)childModules[i].loadAdapter(IJ2EEModule.class, monitor)) != null && childModule.isBinary() ? new Path("WEB-INF/lib").append(childModules[i].getName()) : new Path("WEB-INF/lib").append(String.valueOf(childModules[i].getName()) + ".jar"));
                    ++i;
                }
            }
            IStatus[] stat = helper.publishSmart(mr, path, jarPaths, monitor);
            PublishOperation2.addArrayToList(status, stat);
            p.put(module[0].getId(), path.toOSString());
        }
        PublishOperation2.throwException(status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishJar(String jarURI, int kind, int deltaKind, Properties p, IModule[] module, PublishHelper helper, IProgressMonitor monitor) throws CoreException {
        if (deltaKind == 3 || this.getJettyServer().isServeModulesWithoutPublish()) {
            try {
                String publishPath = (String)p.get(module[1].getId());
                if (publishPath == null) return;
                new File(publishPath).delete();
                p.remove(module[1].getId());
                return;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.jetty.core", 0, "Could not remove module", (Throwable)e));
            }
        } else {
            IModuleResourceDelta[] delta;
            IPath jarPath;
            IPath path = this.getModuleDeployDirectory(module[0]);
            if (jarURI == null) {
                jarURI = "WEB-INF/lib" + module[1].getName() + ".jar";
            }
            if (!(path = (jarPath = path.append(jarURI)).removeLastSegments(1)).toFile().exists()) {
                path.toFile().mkdirs();
            } else if (jarPath.toFile().exists() && kind != 4 && kind != 2 && ((delta = this.getPublishedResourceDelta(module)) == null || delta.length == 0)) {
                return;
            }
            IModuleResource[] mr = this.getResources(module);
            IStatus[] stat = helper.publishZip(mr, jarPath, monitor);
            ArrayList<IStatus> status = new ArrayList<IStatus>();
            PublishOperation2.addArrayToList(status, stat);
            PublishOperation2.throwException(status);
            p.put(module[1].getId(), jarPath.toOSString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishArchiveModule(String jarURI, int kind, int deltaKind, Properties p, IModule[] module, PublishHelper helper, IProgressMonitor monitor) throws CoreException {
        if (deltaKind == 3 || this.getJettyServer().isServeModulesWithoutPublish()) {
            try {
                String publishPath = (String)p.get(module[1].getId());
                if (publishPath == null) return;
                new File(publishPath).delete();
                p.remove(module[1].getId());
                return;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.jetty.core", 0, "Could not remove archive module", (Throwable)e));
            }
        } else {
            IModuleResourceDelta[] delta;
            IPath jarPath;
            ArrayList<IStatus> status = new ArrayList<IStatus>();
            IPath path = this.getModuleDeployDirectory(module[0]);
            if (jarURI == null) {
                jarURI = "WEB-INF/lib" + module[1].getName();
            }
            if (!(path = (jarPath = path.append(jarURI)).removeLastSegments(1)).toFile().exists()) {
                path.toFile().mkdirs();
            } else if (jarPath.toFile().exists() && kind != 4 && kind != 2 && ((delta = this.getPublishedResourceDelta(module)) == null || delta.length == 0)) {
                return;
            }
            IModuleResource[] mr = this.getResources(module);
            IStatus[] stat = helper.publishToPath(mr, jarPath, monitor);
            PublishOperation2.addArrayToList(status, stat);
            PublishOperation2.throwException(status);
            p.put(module[1].getId(), jarPath.toOSString());
        }
    }

    public IPath getServerDeployDirectory() {
        return this.getJettyServer().getServerDeployDirectory();
    }

    protected IModuleResource[] getResources(IModule[] module) {
        return super.getResources(module);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public IPath getModuleDeployDirectory(IModule module) {
        return this.getServerDeployDirectory().append(module.getName());
    }

    public IPath getPublishDirectory(IModule[] module) {
        if (module == null || module.length != 1) {
            return null;
        }
        return this.getModuleDeployDirectory(module[0]);
    }

    public void setModulePublishState2(IModule[] module, int state) {
        this.setModulePublishState(module, state);
    }

    public Properties loadModulePublishLocations() {
        Properties p;
        block11: {
            p = new Properties();
            IPath path = this.getTempDirectory().append("publish.txt");
            FileInputStream fin = null;
            try {
                try {
                    fin = new FileInputStream(path.toFile());
                    p.load(fin);
                }
                catch (Exception exception) {
                    try {
                        fin.close();
                    }
                    catch (Exception exception2) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
        return p;
    }

    public void saveModulePublishLocations(Properties p) {
        block11: {
            IPath path = this.getTempDirectory().append("publish.txt");
            FileOutputStream fout = null;
            try {
                try {
                    fout = new FileOutputStream(path.toFile());
                    p.store(fout, "Jetty publish data");
                }
                catch (Exception exception) {
                    try {
                        fout.close();
                    }
                    catch (Exception exception2) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fout.close();
            }
            catch (Exception exception) {}
        }
    }
}

