/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.jetty.core.internal.wst.IModuleVisitor;
import org.eclipse.jst.server.jetty.core.internal.wst.ModuleTraverser;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class JettySourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        SourcePathComputerVisitor visitor = new SourcePathComputerVisitor(configuration);
        IModule[] modules = server.getModules();
        int i = 0;
        while (i < modules.length) {
            ModuleTraverser.traverse(modules[i], visitor, monitor);
            ++i;
        }
        return visitor.getSourceContainers();
    }

    class SourcePathComputerVisitor
    implements IModuleVisitor {
        final ILaunchConfiguration configuration;
        List<IRuntimeClasspathEntry> runtimeClasspath = new ArrayList<IRuntimeClasspathEntry>();

        SourcePathComputerVisitor(ILaunchConfiguration configuration) {
            this.configuration = configuration;
        }

        public void visitWebComponent(IVirtualComponent component) throws CoreException {
            IProject project = component.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                this.runtimeClasspath.add(JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)javaProject));
            }
        }

        public void endVisitWebComponent(IVirtualComponent component) throws CoreException {
        }

        public void visitArchiveComponent(IPath runtimePath, IPath workspacePath) {
        }

        public void visitDependentComponent(IPath runtimePath, IPath workspacePath) {
        }

        public void visitWebResource(IPath runtimePath, IPath workspacePath) {
        }

        public void visitDependentContentResource(IPath runtimePath, IPath workspacePath) {
        }

        public void visitEarResource(IPath runtimePath, IPath workspacePath) {
        }

        public void endVisitEarComponent(IVirtualComponent component) throws CoreException {
        }

        public void visitClasspathEntry(IPath rtFolder, IClasspathEntry entry) {
        }

        ISourceContainer[] getSourceContainers() throws CoreException {
            this.runtimeClasspath.addAll(Arrays.asList(JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)this.configuration)));
            IRuntimeClasspathEntry[] entries = this.runtimeClasspath.toArray(new IRuntimeClasspathEntry[this.runtimeClasspath.size()]);
            IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)this.configuration);
            return JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
        }
    }
}

