/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jst.server.jetty.core.IJettyConfiguration;
import org.eclipse.jst.server.jetty.core.internal.IJettyVersionHandler;
import org.eclipse.jst.server.jetty.core.internal.IJettyVersionProvider;
import org.eclipse.jst.server.jetty.core.internal.jetty7.Jetty7Provider;
import org.eclipse.jst.server.jetty.core.internal.jetty8.Jetty8Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyVersionManager {
    public static final JettyVersionManager __INSTANCE = new JettyVersionManager();
    private Map<String, IJettyVersionProvider> _versionProviders = new HashMap<String, IJettyVersionProvider>();
    private List<String> _runtimeTypes = new ArrayList<String>();

    private JettyVersionManager() {
        this.register(JettyVersion.V71, Jetty7Provider.__INSTANCE);
        this.register(JettyVersion.V72, Jetty7Provider.__INSTANCE);
        this.register(JettyVersion.V73, Jetty7Provider.__INSTANCE);
        this.register(JettyVersion.V74, Jetty7Provider.__INSTANCE);
        this.register(JettyVersion.V75, Jetty7Provider.__INSTANCE);
        this.register(JettyVersion.V76, Jetty7Provider.__INSTANCE);
        this.register(JettyVersion.V80, Jetty8Provider.__INSTANCE);
        this.register(JettyVersion.V81, Jetty8Provider.__INSTANCE);
    }

    public void register(JettyVersion version, IJettyVersionProvider versionProvider) {
        this._versionProviders.put(version.name(), versionProvider);
        String versionNumber = version.name().substring(1, version.name().length());
        this._runtimeTypes.add("org.eclipse.jst.server.jetty.runtime." + versionNumber);
    }

    public IJettyVersionHandler getJettyVersionHandler(String id) {
        String version = this.getVersion(id);
        IJettyVersionProvider versionProvider = this._versionProviders.get(version);
        if (versionProvider == null) {
            throw new JettyVersionHandlerNotFoundException(version);
        }
        return versionProvider.getJettyVersionHandler();
    }

    public IJettyConfiguration getJettyConfiguration(String id, IFolder path) {
        String version = this.getVersion(id);
        IJettyVersionProvider versionProvider = this._versionProviders.get(version);
        if (versionProvider == null) {
            throw new JettyVersionHandlerNotFoundException(version);
        }
        return versionProvider.createJettyConfiguration(path);
    }

    private String getVersion(String id) {
        String version = id;
        int index = version.lastIndexOf(46);
        if (index != -1) {
            version = version.substring(index + 1, version.length());
        }
        if (!version.startsWith("v")) {
            version = "v" + version;
        }
        version = version.toUpperCase();
        return version;
    }

    public Collection<String> getRuntimeTypes() {
        return this._runtimeTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JettyVersion {
        V71,
        V72,
        V73,
        V74,
        V75,
        V76,
        V80,
        V81;

    }

    private static class JettyVersionHandlerNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private static final String MESSAGE = "Version Handler not founded with serverType={0}.";

        public JettyVersionHandlerNotFoundException(String serverType) {
            super(MessageFormat.format(MESSAGE, serverType));
        }
    }
}

