/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jst.server.jetty.core.internal.JettyServerBehaviour;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;

public class PingThread {
    private static final int __PING_DELAY = 2000;
    private static final int __PING_INTERVAL = 250;
    private int _maxPings;
    private boolean _stop = false;
    private String _url;
    private IServer _server;
    private JettyServerBehaviour _behaviour;

    public PingThread(IServer server, String url, int maxPings, JettyServerBehaviour behaviour) {
        this._server = server;
        this._url = url;
        this._maxPings = maxPings;
        this._behaviour = behaviour;
        Thread t = new Thread("Jetty Ping Thread"){

            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this._stop) {
            try {
                if (count == this._maxPings) {
                    try {
                        this._server.stop(false);
                    }
                    catch (Exception exception) {
                        Trace.trace((byte)4, "Ping: could not stop server");
                    }
                    this._stop = true;
                    break;
                }
                Trace.trace((byte)4, "Ping: pinging " + ++count);
                URL pingUrl = new URL(this._url);
                URLConnection conn = pingUrl.openConnection();
                ((HttpURLConnection)conn).getResponseCode();
                if (!this._stop) {
                    Trace.trace((byte)4, "Ping: success");
                    Thread.sleep(200L);
                    this._behaviour.setServerStarted();
                }
                this._stop = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
                this._behaviour.setServerStarted();
                this._stop = true;
            }
            catch (Exception exception) {
                Trace.trace((byte)4, "Ping: failed");
                if (this._stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        Trace.trace((byte)4, "Ping: stopping");
        this._stop = true;
    }
}

