/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.jetty.core.internal.JettyServerBehaviour;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.util.PublishHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishOperation2
extends PublishOperation {
    protected JettyServerBehaviour _server;
    protected IModule[] _module;
    protected int _kind;
    protected int _deltaKind;
    private PublishHelper _helper;

    public PublishOperation2(JettyServerBehaviour server, int kind, IModule[] module, int deltaKind) {
        super("Publish to server", "Publish Web module to Jetty server");
        this._server = server;
        this._module = module;
        this._kind = kind;
        this._deltaKind = deltaKind;
        IPath base = server.getRuntimeBaseDirectory();
        this._helper = base != null ? new PublishHelper(base.append("temp").toFile()) : new PublishHelper(null);
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (this._module.length == 1) {
            this.publishDir(this._module[0], status, monitor);
        } else {
            Properties p = this._server.loadModulePublishLocations();
            IWebModule webModule = (IWebModule)this._module[0].loadAdapter(IWebModule.class, monitor);
            String childURI = null;
            if (webModule != null) {
                childURI = webModule.getURI(this._module[1]);
            }
            IJ2EEModule childModule = (IJ2EEModule)this._module[1].loadAdapter(IJ2EEModule.class, monitor);
            boolean isBinary = false;
            if (childModule != null) {
                isBinary = childModule.isBinary();
            }
            if (isBinary) {
                this.publishArchiveModule(childURI, p, status, monitor);
            } else {
                this.publishJar(childURI, p, status, monitor);
            }
            this._server.saveModulePublishLocations(p);
        }
        PublishOperation2.throwException(status);
        this._server.setModulePublishState2(this._module, 1);
    }

    private void publishDir(IModule module2, List status, IProgressMonitor monitor) throws CoreException {
        IStatus[] stat;
        IPath path = this._server.getModuleDeployDirectory(module2);
        if (this._kind == 4 || this._deltaKind == 3 || this._server.getJettyServer().isServeModulesWithoutPublish()) {
            File f = path.toFile();
            if (f.exists()) {
                stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                PublishOperation2.addArrayToList(status, stat);
            }
            if (this._deltaKind == 3 || this._server.getJettyServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (this._kind == 4 || this._kind == 2) {
            IModuleResource[] mr = this._server.getResources(this._module);
            stat = this._helper.publishFull(mr, path, monitor);
            PublishOperation2.addArrayToList(status, stat);
            return;
        }
        IModuleResourceDelta[] delta = this._server.getPublishedResourceDelta(this._module);
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat2 = this._helper.publishDelta(delta[i], path, monitor);
            PublishOperation2.addArrayToList(status, stat2);
            ++i;
        }
    }

    private void publishJar(String jarURI, Properties p, List status, IProgressMonitor monitor) throws CoreException {
        IModuleResourceDelta[] delta;
        IPath jarPath;
        IPath path = this._server.getModuleDeployDirectory(this._module[0]);
        boolean moving = false;
        String oldURI = (String)p.get(this._module[1].getId());
        if (oldURI != null && jarURI != null) {
            boolean bl = moving = !oldURI.equals(jarURI);
        }
        if (jarURI == null) {
            jarURI = "WEB-INF/lib/" + this._module[1].getName() + ".jar";
        }
        IPath oldJarPath = jarPath = path.append(jarURI);
        if (oldURI != null) {
            oldJarPath = path.append(oldURI);
        }
        path = jarPath.removeLastSegments(1);
        if (moving || this._kind == 4 || this._deltaKind == 3 || this._server.getJettyServer().isServeModulesWithoutPublish()) {
            File file = oldJarPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            p.remove(this._module[1].getId());
            if (this._deltaKind == 3 || this._server.getJettyServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (!(moving || this._kind == 4 || this._kind == 2 || (delta = this._server.getPublishedResourceDelta(this._module)) != null && delta.length != 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this._server.getResources(this._module);
        IStatus[] stat = this._helper.publishZip(mr, jarPath, monitor);
        PublishOperation2.addArrayToList(status, stat);
        p.put(this._module[1].getId(), jarURI);
    }

    private void publishArchiveModule(String jarURI, Properties p, List status, IProgressMonitor monitor) {
        IModuleResourceDelta[] delta;
        IPath jarPath;
        IPath path = this._server.getModuleDeployDirectory(this._module[0]);
        boolean moving = false;
        String oldURI = (String)p.get(this._module[1].getId());
        if (oldURI != null && jarURI != null) {
            boolean bl = moving = !oldURI.equals(jarURI);
        }
        if (jarURI == null) {
            jarURI = "WEB-INF/lib/" + this._module[1].getName();
        }
        IPath oldJarPath = jarPath = path.append(jarURI);
        if (oldURI != null) {
            oldJarPath = path.append(oldURI);
        }
        path = jarPath.removeLastSegments(1);
        if (moving || this._kind == 4 || this._deltaKind == 3 || this._server.getJettyServer().isServeModulesWithoutPublish()) {
            File file = oldJarPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            p.remove(this._module[1].getId());
            if (this._deltaKind == 3 || this._server.getJettyServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (!(moving || this._kind == 4 || this._kind == 2 || (delta = this._server.getPublishedResourceDelta(this._module)) != null && delta.length != 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this._server.getResources(this._module);
        IStatus[] stat = this._helper.publishToPath(mr, jarPath, monitor);
        PublishOperation2.addArrayToList(status, stat);
        p.put(this._module[1].getId(), jarURI);
    }

    protected static void throwException(List<IStatus> status) throws CoreException {
        if (status == null || status.size() == 0) {
            return;
        }
        if (status.size() == 1) {
            IStatus status2 = status.get(0);
            throw new CoreException(status2);
        }
        IStatus[] children = new IStatus[status.size()];
        status.toArray(children);
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.jst.server.jetty.core", 0, children, message, null);
        throw new CoreException((IStatus)status2);
    }

    protected static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

