/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.zip.ZipException;
import org.eclipse.jst.server.jetty.core.internal.util.IOUtils;

public class StartConfig {
    public static InputStream getInputStream(File startJARFile) throws ZipException, IOException {
        InputStream stream = IOUtils.getInputStream(startJARFile, "org/eclipse/jetty/start/start.config");
        boolean hasJSPModule = false;
        InputStreamReader input = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(input);
        StringWriter newContent = new StringWriter();
        newContent.append("jetty.home/=$(jetty.home)");
        newContent.append('\n');
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("jetty.home")) {
                line = "#" + line;
            } else {
                if (line.indexOf("$(jetty.home)") != -1 && (line.indexOf("/lib/") != -1 || line.indexOf(".jar") != -1)) {
                    line = line.replaceAll("jetty.home", "install.jetty.home");
                }
                hasJSPModule = line.startsWith("[jsp]");
            }
            newContent.append(line);
            newContent.append('\n');
            line = reader.readLine();
        }
        if (!hasJSPModule) {
            newContent.append("# Add jsp");
            newContent.append('\n');
            newContent.append("[jsp]");
            newContent.append('\n');
            newContent.append("$(install.jetty.home)/lib/jsp/**");
            newContent.append('\n');
        }
        return IOUtils.toInputStream(newContent.toString(), "UTF-8");
    }
}

